"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexSelectPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/triggers-actions-ui-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_alerts/public/rule_types/components/index_select_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const IndexSelectPopover = ({
  index,
  esFields,
  timeField,
  errors,
  onIndexChange,
  onTimeFieldChange
}) => {
  const {
    http
  } = (0, _public.useKibana)().services;
  const [indexPopoverOpen, setIndexPopoverOpen] = (0, _react.useState)(false);
  const [indexOptions, setIndexOptions] = (0, _react.useState)([]);
  const [areIndicesLoading, setAreIndicesLoading] = (0, _react.useState)(false);
  const [timeFieldOptions, setTimeFieldOptions] = (0, _react.useState)([_public2.firstFieldOption]);
  const loadIndexOptions = (0, _lodash.debounce)(async search => {
    setAreIndicesLoading(true);
    setIndexOptions(await (0, _public2.getIndexOptions)(http, search));
    setAreIndicesLoading(false);
  }, 250);
  (0, _react.useEffect)(() => {
    const timeFields = (0, _public2.getTimeFieldOptions)(esFields);
    setTimeFieldOptions([_public2.firstFieldOption, ...timeFields]);
  }, [esFields]);
  const renderIndices = indices => {
    const rows = indices.map((indexName, idx) => {
      return /*#__PURE__*/_react.default.createElement("p", {
        key: idx,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 81,
          columnNumber: 9
        }
      }, indexName, idx < indices.length - 1 ? ',' : null);
    });
    return /*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 12
      }
    }, rows);
  };
  const closeIndexPopover = () => {
    setIndexPopoverOpen(false);
    if (timeField === undefined) {
      onTimeFieldChange('');
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "indexPopover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      display: "columns",
      "data-test-subj": "selectIndexExpression",
      description: _i18n.i18n.translate('xpack.stackAlerts.components.ui.alertParams.indexLabel', {
        defaultMessage: 'index'
      }),
      value: index && index.length > 0 ? renderIndices(index) : _i18n.i18n.translate('xpack.stackAlerts.components.ui.alertParams.indexPlaceholder', {
        defaultMessage: 'Select indices and a time field'
      }),
      isActive: indexPopoverOpen,
      onClick: () => {
        setIndexPopoverOpen(true);
      },
      isInvalid: !(index && index.length > 0 && timeField !== ''),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 9
      }
    }),
    isOpen: indexPopoverOpen,
    closePopover: closeIndexPopover,
    ownFocus: true,
    anchorPosition: "downLeft",
    zIndex: 8000,
    display: "block",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '450px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.stackAlerts.components.ui.alertParams.indexButtonLabel', {
    defaultMessage: 'index'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "closePopover",
    iconType: "cross",
    color: "danger",
    "aria-label": _i18n.i18n.translate('xpack.stackAlerts.components.ui.alertParams.closeIndexPopoverLabel', {
      defaultMessage: 'Close'
    }),
    onClick: closeIndexPopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "indexSelectSearchBox",
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.stackAlerts.components.ui.alertParams.indicesToQueryLabel",
      defaultMessage: "Indices to query",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 13
      }
    })
    // @ts-expect-error upgrade typescript v5.1.6
    ,
    isInvalid: errors.index.length > 0 && index != null && index.length > 0,
    error: errors.index,
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.stackAlerts.components.ui.alertParams.howToBroadenSearchQueryDescription",
      defaultMessage: "Use * to broaden your query.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    async: true,
    isLoading: areIndicesLoading
    // @ts-expect-error upgrade typescript v5.1.6
    ,
    isInvalid: errors.index.length > 0 && index != null && index.length > 0,
    noSuggestions: !indexOptions.length,
    options: indexOptions,
    "data-test-subj": "thresholdIndexesComboBox",
    selectedOptions: (index || []).map(anIndex => {
      return {
        label: anIndex,
        value: anIndex
      };
    }),
    onChange: async selected => {
      const selectedIndices = selected.map(aSelected => aSelected.value).filter(_lodash.isString);
      onIndexChange(selectedIndices);

      // reset time field if indices have been reset
      if (selectedIndices.length === 0) {
        setTimeFieldOptions([_public2.firstFieldOption]);
      } else {
        const currentEsFields = await (0, _public2.getFields)(http, selectedIndices);
        const timeFields = (0, _public2.getTimeFieldOptions)(currentEsFields);
        setTimeFieldOptions([_public2.firstFieldOption, ...timeFields]);
      }
    },
    onSearchChange: loadIndexOptions,
    onBlur: () => {
      if (!index) {
        onIndexChange([]);
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "thresholdTimeField",
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.stackAlerts.components.ui.alertParams.timeFieldLabel",
      defaultMessage: "Time field",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 213,
        columnNumber: 13
      }
    })
    // @ts-expect-error upgrade typescript v5.1.6
    ,
    isInvalid: errors.timeField.length > 0 && timeField !== undefined,
    error: errors.timeField,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: timeFieldOptions
    // @ts-expect-error upgrade typescript v5.1.6
    ,
    isInvalid: errors.timeField.length > 0 && timeField !== undefined,
    fullWidth: true,
    name: "thresholdTimeField",
    "data-test-subj": "thresholdAlertTimeFieldSelect",
    value: timeField || '',
    onChange: e => {
      onTimeFieldChange(e.target.value);
    },
    onBlur: () => {
      if (timeField === undefined) {
        onTimeFieldChange('');
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 11
    }
  }))));
};
exports.IndexSelectPopover = IndexSelectPopover;