"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessingCopyToSpace = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _space_result = require("./space_result");
var _lib = require("../lib");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/spaces/public/copy_saved_objects_to_space/components/processing_copy_to_space.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const renderCopyOptions = ({
  createNewCopies,
  overwrite,
  includeRelated
}) => {
  const createNewCopiesLabel = createNewCopies ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.spaces.management.copyToSpace.createNewCopiesLabel",
    defaultMessage: "Create new objects with random IDs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.spaces.management.copyToSpace.dontCreateNewCopiesLabel",
    defaultMessage: "Check for existing objects",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    className: "spcCopyToSpaceOptionsView",
    flush: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    iconType: "copy",
    label: createNewCopiesLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }), !createNewCopies && /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    iconType: overwrite ? 'check' : 'cross',
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.copyToSpace.overwriteLabel",
      defaultMessage: "Automatically overwrite conflicts",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    iconType: includeRelated ? 'check' : 'cross',
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.copyToSpace.includeRelatedLabel",
      defaultMessage: "Include related saved objects",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }));
};
const ProcessingCopyToSpace = props => {
  function updateRetries(spaceId, updatedRetries) {
    props.onRetriesChange({
      ...props.retries,
      [spaceId]: updatedRetries
    });
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "copy-to-space-processing",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 5
    }
  }, renderCopyOptions(props.copyOptions), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.spaces.management.copyToSpace.copyResultsLabel",
    defaultMessage: "Results",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }), props.copyOptions.selectedSpaceIds.map(id => {
    const space = props.spaces.find(s => s.id === id);
    const spaceCopyResult = props.copyResult[space.id];
    const summarizedSpaceCopyResult = (0, _lib.summarizeCopyResult)(props.savedObjectTarget, spaceCopyResult);
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 11
      }
    }, summarizedSpaceCopyResult.processing ? /*#__PURE__*/_react.default.createElement(_space_result.SpaceResultProcessing, {
      space: space,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 15
      }
    }) : /*#__PURE__*/_react.default.createElement(_space_result.SpaceResult, {
      space: space,
      summarizedCopyResult: summarizedSpaceCopyResult,
      retries: props.retries[space.id] || [],
      onRetriesChange: retries => updateRetries(space.id, retries),
      conflictResolutionInProgress: props.conflictResolutionInProgress,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 13
      }
    }));
  }));
};
exports.ProcessingCopyToSpace = ProcessingCopyToSpace;