"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyDetails = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _app_context = require("../../../../app_context");
var _shared_imports = require("../../../../../shared_imports");
var _constants = require("../../../../constants");
var _http = require("../../../../services/http");
var _navigation = require("../../../../services/navigation");
var _components = require("../../../../components");
var _tabs = require("./tabs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/snapshot_restore/public/application/sections/home/policy_list/policy_details/policy_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TAB_SUMMARY = 'summary';
const TAB_HISTORY = 'success';
const tabToUiMetricMap = {
  [TAB_SUMMARY]: _constants.UIM_POLICY_DETAIL_PANEL_SUMMARY_TAB,
  [TAB_HISTORY]: _constants.UIM_POLICY_DETAIL_PANEL_HISTORY_TAB
};
const PolicyDetails = ({
  policyName,
  onClose,
  onPolicyDeleted,
  onPolicyExecuted
}) => {
  const {
    i18n,
    uiMetricService,
    history
  } = (0, _app_context.useServices)();
  const {
    error,
    data: policyDetails,
    resendRequest: reload
  } = (0, _http.useLoadPolicy)(policyName);
  const [activeTab, setActiveTab] = (0, _react.useState)(TAB_SUMMARY);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);

  // Reset tab when we look at a different policy
  (0, _react.useEffect)(() => {
    setActiveTab(TAB_SUMMARY);
  }, [policyName]);
  const tabOptions = [{
    id: TAB_SUMMARY,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyDetails.summaryTabTitle",
      defaultMessage: "Summary",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 9
      }
    })
  }, {
    id: TAB_HISTORY,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyDetails.historyTabTitle",
      defaultMessage: "History",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 9
      }
    })
  }];
  const renderTabs = () => /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 5
    }
  }, tabOptions.map(tab => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    onClick: () => {
      uiMetricService.trackUiMetric(tabToUiMetricMap[tab.id]);
      setActiveTab(tab.id);
    },
    isSelected: tab.id === activeTab,
    key: tab.id,
    "data-test-subj": "tab",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  }, tab.name)));
  const renderBody = () => {
    if (policyDetails) {
      const {
        policy
      } = policyDetails;
      switch (activeTab) {
        case TAB_HISTORY:
          return /*#__PURE__*/_react.default.createElement(_tabs.TabHistory, {
            policy: policy,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 126,
              columnNumber: 18
            }
          });
        default:
          return /*#__PURE__*/_react.default.createElement(_tabs.TabSummary, {
            policy: policy,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 128,
              columnNumber: 18
            }
          });
      }
    }
    if (error) {
      return renderError();
    }
    return renderLoading();
  };
  const renderLoading = () => {
    return /*#__PURE__*/_react.default.createElement(_components.SectionLoading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyDetails.loadingPolicyDescription",
      defaultMessage: "Loading policy\u2026",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 9
      }
    }));
  };
  const renderError = () => {
    const notFound = error.status === 404;
    const errorObject = notFound ? {
      data: {
        error: i18n.translate('xpack.snapshotRestore.policyDetails.policyNotFoundErrorMessage', {
          defaultMessage: `The policy ''{name}'' does not exist.`,
          values: {
            name: policyName
          }
        })
      }
    } : error;
    return /*#__PURE__*/_react.default.createElement(_shared_imports.SectionError, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.policyDetails.loadingPolicyErrorTitle",
        defaultMessage: "Error loading policy",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 168,
          columnNumber: 11
        }
      }),
      error: errorObject,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 7
      }
    });
  };
  const renderFooter = () => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 180,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "cross",
      flush: "left",
      onClick: onClose,
      "data-test-subj": "srPolicyDetailsFlyoutCloseButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyDetails.closeButtonLabel",
      defaultMessage: "Close",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 188,
        columnNumber: 13
      }
    }))), policyDetails ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 195,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_components.PolicyExecuteProvider, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 196,
        columnNumber: 13
      }
    }, executePolicyPrompt => {
      return /*#__PURE__*/_react.default.createElement(_components.PolicyDeleteProvider, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 199,
          columnNumber: 19
        }
      }, deletePolicyPrompt => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
          id: "policyActionMenu",
          button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
            "data-test-subj": "policyActionMenuButton",
            iconSide: "right",
            onClick: () => setIsPopoverOpen(!isPopoverOpen),
            iconType: "arrowDown",
            fill: true,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 205,
              columnNumber: 29
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.snapshotRestore.policyDetails.manageButtonLabel",
            defaultMessage: "Manage policy",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 212,
              columnNumber: 31
            }
          })),
          isOpen: isPopoverOpen,
          closePopover: () => setIsPopoverOpen(false),
          panelPaddingSize: "none",
          anchorPosition: "rightUp",
          repositionOnScroll: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 202,
            columnNumber: 25
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
          "data-test-subj": "policyActionContextMenu",
          initialPanelId: 0,
          panels: [{
            id: 0,
            title: i18n.translate('xpack.snapshotRestore.policyDetails.managePanelTitle', {
              defaultMessage: 'Policy options'
            }),
            items: [{
              name: i18n.translate('xpack.snapshotRestore.policyDetails.executeButtonLabel', {
                defaultMessage: 'Run now'
              }),
              icon: 'play',
              onClick: () => {
                executePolicyPrompt(policyName, () =>
                // Wait a little bit for policy to execute before reloading policy table
                // and policy details so that History tab information is updated with
                // results of the execution
                setTimeout(() => {
                  onPolicyExecuted();
                  reload();
                }, 2000));
              },
              disabled: Boolean(policyDetails.policy.inProgress),
              'data-test-subj': 'policyActionMenuRunPolicy'
            }, {
              name: i18n.translate('xpack.snapshotRestore.policyDetails.editButtonLabel', {
                defaultMessage: 'Edit'
              }),
              icon: 'pencil',
              ...(0, _public.reactRouterNavigate)(history, (0, _navigation.linkToEditPolicy)(policyName))
            }, {
              name: i18n.translate('xpack.snapshotRestore.policyDetails.deleteButtonLabel', {
                defaultMessage: 'Delete'
              }),
              icon: 'trash',
              disabled: policyDetails.policy.isManagedPolicy,
              onClick: () => deletePolicyPrompt([policyName], onPolicyDeleted)
            }]
          }],
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 224,
            columnNumber: 27
          }
        }));
      });
    })) : null);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    "data-test-subj": "policyDetail",
    "aria-labelledby": "srPolicyDetailsFlyoutTitle",
    size: "m",
    maxWidth: 550,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "srPolicyDetailsFlyoutTitle",
    "data-test-subj": "title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 308,
      columnNumber: 11
    }
  }, policyName, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "refresh",
    color: "text",
    "aria-label": i18n.translate('xpack.snapshotRestore.policyDetails.reloadButtonAriaLabel', {
      defaultMessage: 'Reload'
    }),
    onClick: () => reload(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 310,
      columnNumber: 13
    }
  }))), policyDetails && policyDetails.policy && policyDetails.policy.inProgress ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 323,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_components.InlineLoading, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({}, (0, _public.reactRouterNavigate)(history, (0, _navigation.linkToSnapshot)(policyDetails.policy.repository, policyDetails.policy.inProgress.snapshotName)), {
    "data-test-subj": "inProgressSnapshotLink",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 325,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.inProgressSnapshotLinkText",
    defaultMessage: "''{snapshotName}'' in progress",
    values: {
      snapshotName: policyDetails.policy.inProgress.snapshotName
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 335,
      columnNumber: 17
    }
  })))) : null, renderTabs()), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    "data-test-subj": "content",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 347,
      columnNumber: 7
    }
  }, renderBody()), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 349,
      columnNumber: 7
    }
  }, renderFooter()));
};
exports.PolicyDetails = PolicyDetails;