"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RepositoryTypeLogo = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/snapshot_restore/public/application/components/repository_type_logo.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const RepositoryTypeLogo = ({
  type,
  ...rest
}) => {
  const typeLogoMap = {
    [_constants.REPOSITORY_TYPES.fs]: 'storage',
    [_constants.REPOSITORY_TYPES.url]: 'eye',
    [_constants.REPOSITORY_TYPES.azure]: 'logoAzure',
    [_constants.REPOSITORY_TYPES.gcs]: 'logoGCP',
    [_constants.REPOSITORY_TYPES.hdfs]: 'logoApache',
    [_constants.REPOSITORY_TYPES.s3]: 'logoAWS'
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, (0, _extends2.default)({
    type: typeLogoMap[type] || 'folderOpen'
  }, rest, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 10
    }
  }));
};
exports.RepositoryTypeLogo = RepositoryTypeLogo;