"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findSLOGroupsRoute = void 0;
var _sloSchema = require("@kbn/slo-schema");
var _services = require("../../services");
var _create_slo_server_route = require("../create_slo_server_route");
var _assert_platinum_license = require("./utils/assert_platinum_license");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findSLOGroupsRoute = exports.findSLOGroupsRoute = (0, _create_slo_server_route.createSloServerRoute)({
  endpoint: 'GET /internal/observability/slos/_groups',
  options: {
    access: 'internal'
  },
  security: {
    authz: {
      requiredPrivileges: ['slo_read']
    }
  },
  params: _sloSchema.findSLOGroupsParamsSchema,
  handler: async ({
    request,
    logger,
    params,
    plugins,
    getScopedClients
  }) => {
    var _params$query;
    await (0, _assert_platinum_license.assertPlatinumLicense)(plugins);
    const {
      scopedClusterClient,
      soClient,
      spaceId
    } = await getScopedClients({
      request,
      logger
    });
    const findSLOGroups = new _services.FindSLOGroups(scopedClusterClient, soClient, logger, spaceId);
    return await findSLOGroups.execute((_params$query = params === null || params === void 0 ? void 0 : params.query) !== null && _params$query !== void 0 ? _params$query : {});
  }
});