"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SettingsForm = SettingsForm;
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../common/constants");
var _use_get_settings = require("./hooks/use_get_settings");
var _use_put_slo_settings = require("./hooks/use_put_slo_settings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_settings/settings_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SettingsForm() {
  const [useAllRemoteClusters, setUseAllRemoteClusters] = (0, _react.useState)(false);
  const [selectedRemoteClusters, setSelectedRemoteClusters] = (0, _react.useState)([]);
  const [staleThresholdInHours, setStaleThresholdInHours] = (0, _react.useState)(_constants.DEFAULT_STALE_SLO_THRESHOLD_HOURS);
  const {
    http
  } = (0, _public.useKibana)().services;
  const {
    data: currentSettings
  } = (0, _use_get_settings.useGetSettings)();
  const {
    mutateAsync: updateSettings,
    isLoading: isUpdating
  } = (0, _use_put_slo_settings.usePutSloSettings)();
  const {
    data,
    loading
  } = (0, _public2.useFetcher)(() => {
    return http === null || http === void 0 ? void 0 : http.get('/api/remote_clusters');
  }, [http]);
  (0, _react.useEffect)(() => {
    if (currentSettings) {
      setUseAllRemoteClusters(currentSettings.useAllRemoteClusters);
      setSelectedRemoteClusters(currentSettings.selectedRemoteClusters);
      setStaleThresholdInHours(currentSettings.staleThresholdInHours);
    }
  }, [currentSettings]);
  const onSubmit = async () => {
    updateSettings({
      settings: {
        useAllRemoteClusters,
        selectedRemoteClusters,
        staleThresholdInHours
      }
    });
  };
  const remoteClustersSwitchLabel = _i18n.i18n.translate('xpack.slo.settingsForm.euiFormRow.useAllRemoteClustersLabel', {
    defaultMessage: 'Use all remote clusters'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.slo.settingsForm.h3.sourceSettingsLabel', {
      defaultMessage: 'Source settings'
    })),
    description: /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.slo.settingsForm.p.fetchSlosFromAllLabel', {
      defaultMessage: 'Fetch SLOs from all remote clusters.'
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: remoteClustersSwitchLabel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: remoteClustersSwitchLabel,
    checked: useAllRemoteClusters,
    onChange: evt => setUseAllRemoteClusters(evt.target.checked),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.slo.settingsForm.h3.remoteSettingsLabel', {
      defaultMessage: 'Remote clusters'
    })),
    description: /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.slo.settingsForm.select.fetchSlosFromAllLabel', {
      defaultMessage: 'Select remote clusters to fetch SLOs from.'
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.slo.settingsForm.euiFormRow.select.selectRemoteClustersLabel', {
      defaultMessage: 'Select remote clusters'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    options: (data === null || data === void 0 ? void 0 : data.map(cluster => ({
      label: cluster.name,
      value: cluster.name
    }))) || [],
    selectedOptions: selectedRemoteClusters.map(cluster => ({
      label: cluster,
      value: cluster
    })),
    onChange: sels => {
      setSelectedRemoteClusters(sels.map(s => s.value));
    },
    isDisabled: useAllRemoteClusters,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.slo.settingsForm.h3.staleThresholdLabel', {
      defaultMessage: 'Stale SLOs threshold'
    })),
    description: /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.slo.settingsForm.select.staleThresholdLabel', {
      defaultMessage: 'SLOs not updated within the defined stale threshold will be hidden by default from the overview list.'
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.slo.settingsForm.euiFormRow.select.selectThresholdLabel', {
      defaultMessage: 'Select threshold'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "data-test-subj": "sloSettingsFormFieldNumber",
    value: staleThresholdInHours,
    onChange: evt => {
      setStaleThresholdInHours(Number(evt.target.value));
    },
    append: _i18n.i18n.translate('xpack.slo.settingsForm.euiFormRow.select.hours', {
      defaultMessage: 'Hours'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    isLoading: loading || isUpdating,
    "data-test-subj": "o11ySettingsFormCancelButton",
    onClick: () => {
      var _currentSettings$stal;
      setUseAllRemoteClusters((currentSettings === null || currentSettings === void 0 ? void 0 : currentSettings.useAllRemoteClusters) || false);
      setSelectedRemoteClusters((currentSettings === null || currentSettings === void 0 ? void 0 : currentSettings.selectedRemoteClusters) || []);
      setStaleThresholdInHours((_currentSettings$stal = currentSettings === null || currentSettings === void 0 ? void 0 : currentSettings.staleThresholdInHours) !== null && _currentSettings$stal !== void 0 ? _currentSettings$stal : _constants.DEFAULT_STALE_SLO_THRESHOLD_HOURS);
    },
    isDisabled: (0, _lodash.isEqual)(currentSettings, {
      useAllRemoteClusters,
      selectedRemoteClusters,
      staleThresholdInHours
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.slo.settingsForm.euiButtonEmpty.cancelLabel', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isLoading: loading || isUpdating,
    "data-test-subj": "o11ySettingsFormSaveButton",
    color: "primary",
    fill: true,
    onClick: () => onSubmit(),
    isDisabled: (0, _lodash.isEqual)(currentSettings, {
      useAllRemoteClusters,
      selectedRemoteClusters,
      staleThresholdInHours
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.slo.settingsForm.applyButtonEmptyLabel', {
    defaultMessage: 'Apply'
  }))))));
}