"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloEditForm = SloEditForm;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _constants = require("../constants");
var _process_slo_form_values = require("../helpers/process_slo_form_values");
var _use_parse_url_state = require("../hooks/use_parse_url_state");
var _use_section_form_validation = require("../hooks/use_section_form_validation");
var _use_show_sections = require("../hooks/use_show_sections");
var _slo_edit_form_description_section = require("./slo_edit_form_description_section");
var _slo_edit_form_footer = require("./slo_edit_form_footer");
var _slo_edit_form_indicator_section = require("./slo_edit_form_indicator_section");
var _slo_edit_form_objective_section = require("./slo_edit_form_objective_section");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_edit/components/slo_edit_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function SloEditForm({
  slo,
  initialValues,
  onSave
}) {
  const isEditMode = slo !== undefined;
  const isFlyoutMode = initialValues !== undefined && onSave !== undefined;
  const sloFormValuesFromFlyoutState = isFlyoutMode ? (0, _process_slo_form_values.transformPartialSLOStateToFormState)(initialValues) : undefined;
  const sloFormValuesFromUrlState = (0, _use_parse_url_state.useParseUrlState)();
  const sloFormValuesFromSloResponse = (0, _process_slo_form_values.transformSloResponseToCreateSloForm)(slo);
  const form = (0, _reactHookForm.useForm)({
    defaultValues: isFlyoutMode ? sloFormValuesFromFlyoutState : sloFormValuesFromUrlState ? sloFormValuesFromUrlState : sloFormValuesFromSloResponse !== null && sloFormValuesFromSloResponse !== void 0 ? sloFormValuesFromSloResponse : _constants.SLO_EDIT_FORM_DEFAULT_VALUES,
    values: isFlyoutMode ? sloFormValuesFromFlyoutState : sloFormValuesFromUrlState ? sloFormValuesFromUrlState : sloFormValuesFromSloResponse,
    mode: 'all'
  });
  const {
    watch,
    getFieldState,
    getValues,
    formState
  } = form;
  const {
    isIndicatorSectionValid,
    isObjectiveSectionValid,
    isDescriptionSectionValid
  } = (0, _use_section_form_validation.useSectionFormValidation)({
    getFieldState,
    getValues,
    formState,
    watch
  });
  const {
    showDescriptionSection,
    showObjectiveSection
  } = (0, _use_show_sections.useShowSections)(isEditMode, formState.isValidating, isIndicatorSectionValid, isObjectiveSectionValid);
  return /*#__PURE__*/_react.default.createElement(_reactHookForm.FormProvider, (0, _extends2.default)({}, form, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    "data-test-subj": "sloForm",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: [{
      title: _i18n.i18n.translate('xpack.slo.sloEdit.definition.title', {
        defaultMessage: 'Define SLI'
      }),
      children: /*#__PURE__*/_react.default.createElement(_slo_edit_form_indicator_section.SloEditFormIndicatorSection, {
        isEditMode: isEditMode,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 83,
          columnNumber: 25
        }
      }),
      status: isIndicatorSectionValid ? 'complete' : 'incomplete'
    }, {
      title: _i18n.i18n.translate('xpack.slo.sloEdit.objectives.title', {
        defaultMessage: 'Set objectives'
      }),
      children: showObjectiveSection ? /*#__PURE__*/_react.default.createElement(_slo_edit_form_objective_section.SloEditFormObjectiveSection, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 90,
          columnNumber: 48
        }
      }) : null,
      status: showObjectiveSection && isObjectiveSectionValid ? 'complete' : 'incomplete'
    }, {
      title: _i18n.i18n.translate('xpack.slo.sloEdit.description.title', {
        defaultMessage: 'Describe SLO'
      }),
      children: showDescriptionSection ? /*#__PURE__*/_react.default.createElement(_slo_edit_form_description_section.SloEditFormDescriptionSection, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 97,
          columnNumber: 50
        }
      }) : null,
      status: showDescriptionSection && isDescriptionSectionValid ? 'complete' : 'incomplete'
    }],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_slo_edit_form_footer.SloEditFormFooter, {
    slo: slo,
    onSave: onSave,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  })));
}