"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloDetailsHistory = SloDetailsHistory;
var _eui = require("@elastic/eui");
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _error_rate_chart = require("../../../../components/slo/error_rate_chart");
var _use_kibana = require("../../../../hooks/use_kibana");
var _duration = require("../../../../utils/slo/duration");
var _events_chart_panel = require("../events_chart_panel/events_chart_panel");
var _historical_data_charts = require("../historical_data_charts");
var _calendar_period_picker = require("./calendar_period_picker");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_details/components/history/slo_details_history.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SloDetailsHistory({
  slo,
  isAutoRefreshing
}) {
  const {
    uiSettings
  } = (0, _use_kibana.useKibana)().services;
  const [range, setRange] = (0, _react.useState)(() => {
    if (slo.timeWindow.type === 'calendarAligned') {
      const now = (0, _moment.default)();
      const duration = (0, _duration.toDuration)(slo.timeWindow.duration);
      const unit = duration.unit === 'w' ? 'isoWeek' : 'month';
      return {
        from: _moment.default.utc(now).startOf(unit).toDate(),
        to: _moment.default.utc(now).endOf(unit).toDate()
      };
    }
    return {
      from: new Date(_datemath.default.parse(`now-${slo.timeWindow.duration}`).valueOf()),
      to: new Date(_datemath.default.parse('now', {
        roundUp: true
      }).valueOf())
    };
  });
  const onBrushed = ({
    from,
    to
  }) => {
    setRange({
      from,
      to
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    direction: "row",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    css: {
      maxWidth: 500
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }, slo.timeWindow.type === 'calendarAligned' ? /*#__PURE__*/_react.default.createElement(_calendar_period_picker.CalendarPeriodPicker, {
    slo: slo,
    onChange: updatedRange => {
      setRange(updatedRange);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    isLoading: false,
    start: range.from.toISOString(),
    end: range.to.toISOString(),
    onTimeChange: val => {
      setRange({
        from: new Date(_datemath.default.parse(val.start).valueOf()),
        to: new Date(_datemath.default.parse(val.end, {
          roundUp: true
        }).valueOf())
      });
    },
    width: "full",
    showUpdateButton: false,
    commonlyUsedRanges: uiSettings.get('timepicker:quickRanges').map(({
      from,
      to,
      display
    }) => ({
      start: from,
      end: to,
      label: display
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    color: "transparent",
    hasBorder: true,
    "data-test-subj": "errorRatePanel",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.slo.sloDetailsHistory.h2.errorRatePanelTitle', {
    defaultMessage: 'Error rate'
  })))), /*#__PURE__*/_react.default.createElement(_error_rate_chart.ErrorRateChart, {
    slo: slo,
    dataTimeRange: range,
    onBrushed: onBrushed,
    variant: ['VIOLATED', 'DEGRADING'].includes(slo.summary.status) ? 'danger' : 'success',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_historical_data_charts.HistoricalDataCharts, {
    slo: slo,
    hideMetadata: true,
    isAutoRefreshing: isAutoRefreshing,
    range: range,
    onBrushed: onBrushed,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_events_chart_panel.EventsChartPanel, {
    slo: slo,
    range: range,
    hideRangeDurationLabel: true,
    onBrushed: onBrushed,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 7
    }
  }));
}