"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateSlo = useCreateSlo;
var _react = _interopRequireDefault(require("react"));
var _rison = require("@kbn/rison");
var _sloSchema = require("@kbn/slo-schema");
var _reactQuery = require("@kbn/react-query");
var _eui = require("@elastic/eui");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _use_kibana = require("./use_kibana");
var _paths = require("../../common/locators/paths");
var _query_key_factory = require("./query_key_factory");
var _use_plugin_context = require("./use_plugin_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/hooks/use_create_slo.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function useCreateSlo() {
  const {
    i18n: i18nStart,
    theme,
    application: {
      navigateToUrl
    },
    http,
    notifications: {
      toasts
    }
  } = (0, _use_kibana.useKibana)().services;
  const {
    sloClient
  } = (0, _use_plugin_context.usePluginContext)();
  const services = (0, _use_kibana.useKibana)().services;
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _reactQuery.useMutation)(['createSlo'], ({
    slo
  }) => {
    return sloClient.fetch(`POST /api/observability/slos 2023-10-31`, {
      params: {
        body: slo
      }
    });
  }, {
    onSuccess: (data, {
      slo
    }) => {
      queryClient.invalidateQueries({
        queryKey: _query_key_factory.sloKeys.lists(),
        exact: false
      });
      const sloEditUrl = http.basePath.prepend(_paths.paths.sloEdit(data.id));
      const sloViewUrl = http.basePath.prepend(_paths.paths.sloDetails(data.id, _sloSchema.ALL_VALUE));
      toasts.addSuccess({
        title: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
          coreStart: services,
          "data-test-subj": "observabilityMainContainer",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 63,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.slo.create.successNotification",
          defaultMessage: "Successfully created {name}. {editSLO} or {viewSLO}",
          values: {
            name: slo.name,
            editSLO: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
              "data-test-subj": "o11yUseCreateSloEditSloLink",
              href: sloEditUrl,
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 70,
                columnNumber: 23
              }
            }, _i18n.i18n.translate('xpack.slo.useCreateSlo.editSLOLinkLabel', {
              defaultMessage: 'Edit SLO'
            })),
            viewSLO: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
              "data-test-subj": "o11yUseCreateSloViewSloLink",
              href: sloViewUrl,
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 77,
                columnNumber: 23
              }
            }, _i18n.i18n.translate('xpack.slo.useCreateSlo.viewSLOLinkLabel', {
              defaultMessage: 'View SLO'
            }))
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 64,
            columnNumber: 17
          }
        })), {
          i18n: i18nStart,
          theme
        })
      }, {
        toastLifeTimeMs: 30000
      });
    },
    onError: (error, {
      slo
    }, context) => {
      var _error$body$message, _error$body;
      toasts.addError(new Error((_error$body$message = (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : error.message), {
        title: _i18n.i18n.translate('xpack.slo.create.errorNotification', {
          defaultMessage: 'Something went wrong while creating {name}',
          values: {
            name: slo.name
          }
        })
      });
      navigateToUrl(http.basePath.prepend(_paths.paths.sloCreateWithEncodedForm((0, _rison.encode)(slo))));
    }
  });
}