"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoadingContent = exports.LoadingContainer = void 0;
exports.SloOverview = SloOverview;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/kibana-react-plugin/common");
var _react = _interopRequireWildcard(require("react"));
var _use_fetch_active_alerts = require("../../../hooks/use_fetch_active_alerts");
var _use_fetch_historical_summary = require("../../../hooks/use_fetch_historical_summary");
var _use_fetch_rules_for_slo = require("../../../hooks/use_fetch_rules_for_slo");
var _use_fetch_slo_details = require("../../../hooks/use_fetch_slo_details");
var _slo_card_item = require("../../../pages/slos/components/card_view/slo_card_item");
var _slo_card_item_badges = require("../../../pages/slos/components/card_view/slo_card_item_badges");
var _chart_data_formatter = require("../../../utils/slo/chart_data_formatter");
var _slo_overview_details = require("../common/slo_overview_details");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/embeddable/slo/overview/slo_overview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SloOverview({
  sloId,
  sloInstanceId,
  remoteName,
  reloadSubject
}) {
  var _historicalSummaries$;
  const [lastRefreshTime, setLastRefreshTime] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(() => {
    reloadSubject === null || reloadSubject === void 0 ? void 0 : reloadSubject.subscribe(() => {
      setLastRefreshTime(Date.now());
    });
    return () => {
      reloadSubject === null || reloadSubject === void 0 ? void 0 : reloadSubject.unsubscribe();
    };
  }, [reloadSubject]);
  const {
    isLoading,
    data: slo,
    refetch,
    isRefetching
  } = (0, _use_fetch_slo_details.useFetchSloDetails)({
    sloId,
    remoteName,
    instanceId: sloInstanceId
  });
  const {
    data: rulesBySlo
  } = (0, _use_fetch_rules_for_slo.useFetchRulesForSlo)({
    sloIds: sloId ? [sloId] : []
  });
  const {
    data: activeAlertsBySlo
  } = (0, _use_fetch_active_alerts.useFetchActiveAlerts)({
    sloIdsAndInstanceIds: slo ? [[slo.id, slo.instanceId]] : []
  });
  const {
    data: historicalSummaries = []
  } = (0, _use_fetch_historical_summary.useFetchHistoricalSummary)({
    sloList: slo ? [slo] : []
  });
  const [selectedSlo, setSelectedSlo] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    refetch();
  }, [lastRefreshTime, refetch]);
  const isSloNotFound = !isLoading && slo === undefined;
  if (isRefetching || isLoading || !slo) {
    return /*#__PURE__*/_react.default.createElement(LoadingContainer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(LoadingContent, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 11
      }
    })));
  }
  if (isSloNotFound) {
    return /*#__PURE__*/_react.default.createElement(LoadingContainer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(LoadingContent, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.slo.sloEmbeddable.overview.sloNotFoundText', {
      defaultMessage: 'The SLO has been deleted. You can safely delete the widget from the dashboard.'
    })));
  }
  const rules = rulesBySlo === null || rulesBySlo === void 0 ? void 0 : rulesBySlo[slo === null || slo === void 0 ? void 0 : slo.id];
  const activeAlerts = activeAlertsBySlo.get(slo);
  const historicalSummary = (_historicalSummaries$ = historicalSummaries.find(histSummary => histSummary.sloId === slo.id && histSummary.instanceId === slo.instanceId)) === null || _historicalSummaries$ === void 0 ? void 0 : _historicalSummaries$.data;
  const historicalSliData = (0, _chart_data_formatter.formatHistoricalData)(historicalSummary, 'sli_value');
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "sloSingleOverviewPanel",
    "data-shared-item": "",
    style: {
      width: '100%'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_slo_card_item.SloCardChart, {
    slo: slo,
    historicalSliData: historicalSliData !== null && historicalSliData !== void 0 ? historicalSliData : [],
    onClick: () => {
      setSelectedSlo(slo);
    },
    badges: /*#__PURE__*/_react.default.createElement(_slo_card_item_badges.SloCardItemBadges, {
      slo: slo,
      rules: rules,
      activeAlerts: activeAlerts,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 17
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_slo_overview_details.SloOverviewDetails, {
    slo: selectedSlo,
    setSelectedSlo: setSelectedSlo,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 7
    }
  }));
}
const LoadingContainer = exports.LoadingContainer = _common.euiStyled.div`
  position: relative;
  overflow: hidden;
  display: flex;
  flex-direction: column;
  justify-content: center;
  width: 100%;
  height: 100%;
`;
const LoadingContent = exports.LoadingContent = _common.euiStyled.div`
  flex: 0 0 auto;
  align-self: center;
  text-align: center;
`;