"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertsEmbeddableFactory = getAlertsEmbeddableFactory;
exports.getAlertsPanelTitle = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _reactQuery = require("@kbn/react-query");
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _presentationContainers = require("@kbn/presentation-containers");
var _plugin_context = require("../../../context/plugin_context");
var _constants = require("./constants");
var _slo_alerts_wrapper = require("./slo_alerts_wrapper");
var _slo_alerts_open_configuration = require("./slo_alerts_open_configuration");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/embeddable/slo/alerts/slo_alerts_embeddable_factory.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const queryClient = new _reactQuery.QueryClient();
const getAlertsPanelTitle = () => _i18n.i18n.translate('xpack.slo.sloAlertsEmbeddable.displayTitle', {
  defaultMessage: 'SLO Alerts'
});
exports.getAlertsPanelTitle = getAlertsPanelTitle;
function getAlertsEmbeddableFactory({
  coreStart,
  pluginsStart,
  sloClient,
  kibanaVersion
}) {
  const factory = {
    type: _constants.SLO_ALERTS_EMBEDDABLE_ID,
    buildEmbeddable: async ({
      initialState,
      finalizeApi,
      uuid,
      parentApi
    }) => {
      const deps = {
        ...coreStart,
        ...pluginsStart
      };
      async function onEdit() {
        try {
          const result = await (0, _slo_alerts_open_configuration.openSloConfiguration)(coreStart, pluginsStart, sloClient, api.getSloAlertsConfig());
          api.updateSloAlertsConfig(result);
        } catch (e) {
          return Promise.reject();
        }
      }
      const titleManager = (0, _presentationPublishing.initializeTitleManager)(initialState.rawState);
      const sloAlertsStateManager = (0, _presentationPublishing.initializeStateManager)(initialState.rawState, {
        slos: [],
        showAllGroupByInstances: false
      });
      const defaultTitle$ = new _rxjs.BehaviorSubject(getAlertsPanelTitle());
      const reload$ = new _rxjs.Subject();
      function serializeState() {
        return {
          rawState: {
            ...titleManager.getLatestState(),
            ...sloAlertsStateManager.getLatestState()
          }
        };
      }
      const unsavedChangesApi = (0, _presentationContainers.initializeUnsavedChanges)({
        uuid,
        parentApi,
        serializeState,
        anyStateChange$: (0, _rxjs.merge)(titleManager.anyStateChange$, sloAlertsStateManager.anyStateChange$),
        getComparators: () => ({
          ..._presentationPublishing.titleComparators,
          slos: 'referenceEquality',
          showAllGroupByInstances: 'referenceEquality'
        }),
        onReset: lastSaved => {
          titleManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
          sloAlertsStateManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
        }
      });
      const api = finalizeApi({
        ...titleManager.api,
        ...unsavedChangesApi,
        defaultTitle$,
        getTypeDisplayName: () => _i18n.i18n.translate('xpack.slo.editSloAlertswEmbeddable.typeDisplayName', {
          defaultMessage: 'configuration'
        }),
        isEditingEnabled: () => true,
        onEdit: async () => {
          onEdit();
        },
        serializeState,
        getSloAlertsConfig: () => {
          return {
            slos: sloAlertsStateManager.api.slos$.getValue(),
            showAllGroupByInstances: sloAlertsStateManager.api.showAllGroupByInstances$.getValue()
          };
        },
        updateSloAlertsConfig: update => {
          sloAlertsStateManager.api.setSlos(update.slos);
          sloAlertsStateManager.api.setShowAllGroupByInstances(update.showAllGroupByInstances);
        }
      });
      const fetchSubscription = (0, _presentationPublishing.fetch$)(api).pipe().subscribe(next => {
        reload$.next(next);
      });
      return {
        api,
        Component: () => {
          var _fetchContext$timeRan;
          const [slos, showAllGroupByInstances] = (0, _presentationPublishing.useBatchedPublishingSubjects)(sloAlertsStateManager.api.slos$, sloAlertsStateManager.api.showAllGroupByInstances$);
          const fetchContext = (0, _presentationPublishing.useFetchContext)(api);
          const I18nContext = deps.i18n.Context;
          (0, _react.useEffect)(() => {
            return () => {
              fetchSubscription.unsubscribe();
            };
          }, []);
          return /*#__PURE__*/_react.default.createElement(I18nContext, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 151,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
            services: {
              ...deps,
              storage: new _public2.Storage(localStorage),
              isServerless: !!deps.serverless,
              kibanaVersion
            },
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 152,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_plugin_context.PluginContext.Provider, {
            value: {
              observabilityRuleTypeRegistry: pluginsStart.observability.observabilityRuleTypeRegistry,
              ObservabilityPageTemplate: pluginsStart.observabilityShared.navigation.PageTemplate,
              sloClient
            },
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 160,
              columnNumber: 17
            }
          }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
            client: queryClient,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 169,
              columnNumber: 19
            }
          }, /*#__PURE__*/_react.default.createElement(_slo_alerts_wrapper.SloAlertsWrapper, {
            onEdit: onEdit,
            deps: deps,
            slos: slos,
            timeRange: (_fetchContext$timeRan = fetchContext.timeRange) !== null && _fetchContext$timeRan !== void 0 ? _fetchContext$timeRan : {
              from: 'now-15m/m',
              to: 'now'
            },
            reloadSubject: reload$,
            showAllGroupByInstances: showAllGroupByInstances,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 170,
              columnNumber: 21
            }
          })))));
        }
      };
    }
  };
  return factory;
}