"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloOutdatedCallout = SloOutdatedCallout;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _rison = require("@kbn/rison");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_fetch_slo_definitions = require("../../../hooks/use_fetch_slo_definitions");
var _paths = require("../../../../common/locators/paths");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/components/slo/slo_outdated_callout/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function SloOutdatedCallout() {
  const {
    application: {
      navigateToUrl
    },
    http: {
      basePath
    }
  } = (0, _use_kibana.useKibana)().services;
  const handleClick = () => {
    navigateToUrl(`${basePath.prepend(_paths.paths.slosManagement)}?search=${(0, _rison.encode)({
      includeOutdatedOnly: true
    })}`);
  };
  const {
    isLoading,
    data
  } = (0, _use_fetch_slo_definitions.useFetchSloDefinitions)({
    includeOutdatedOnly: true
  });
  if (!isLoading && data && data.total > 0) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "warning",
      iconType: "warning",
      title: _i18n.i18n.translate('xpack.slo.outdatedSloCallout.title', {
        defaultMessage: '{total} Outdated SLOs Detected',
        values: {
          total: data.total
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.slo.outdatedSloCallout.message",
      defaultMessage: "We've noticed that you have {total} outdated SLO definitions, these SLOs will not be running or alerting until you've reset them. Please click the button below to review the SLO definitions; you can choose to either reset the SLO definition or remove it.",
      values: {
        total: data.total
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "warning",
      "data-test-subj": "o11ySloOutdatedCalloutViewOutdatedSloDefinitionsButton",
      fill: true,
      onClick: handleClick,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.slo.outdatedSloCallout.buttonLabel",
      defaultMessage: "Review Outdated SLO Definitions",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 15
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 9
      }
    }));
  }
  return null;
}