"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorRatePanel = ErrorRatePanel;
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _react = _interopRequireDefault(require("react"));
var _use_kibana = require("../../../../hooks/use_kibana");
var _error_rate_chart = require("../../../slo/error_rate_chart");
var _alert = require("../../utils/alert");
var _last_duration_i18n = require("../../utils/last_duration_i18n");
var _time_range = require("../../utils/time_range");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/components/alert_details/components/error_rate/error_rate_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function getAlertTimeRange(timeRange) {
  return {
    from: new Date(timeRange.gte),
    to: timeRange.lte ? new Date(timeRange.lte) : new Date()
  };
}
function ErrorRatePanel({
  alert,
  slo,
  isLoading
}) {
  const {
    services: {
      http
    }
  } = (0, _use_kibana.useKibana)();
  const dataTimeRange = (0, _time_range.getDataTimeRange)(alert);
  const actionGroupWindow = (0, _alert.getActionGroupWindow)(alert);
  // @ts-ignore
  const alertTimeRange = getAlertTimeRange(alert.fields[_ruleDataUtils.ALERT_TIME_RANGE]);
  const burnRate = alert.fields[_ruleDataUtils.ALERT_EVALUATION_VALUE];
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
      size: "m",
      "data-test-subj": "loading",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 12
      }
    });
  }
  if (!slo) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    color: "transparent",
    hasBorder: true,
    "data-test-subj": "burnRatePanel",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.slo.burnRateRule.alertDetailsAppSection.burnRate.title', {
    defaultMessage: '{sloName} burn rate',
    values: {
      sloName: slo.name
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    color: "text",
    "data-test-subj": "o11yErrorRatePanelSloDetailsLink",
    href: http.basePath.prepend(alert.link),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "sortRight",
    style: {
      marginRight: '4px'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.burnRateRule.alertDetailsAppSection.burnRate.sloDetailsLink",
    defaultMessage: "SLO details",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 15
    }
  }, (0, _last_duration_i18n.getLastDurationInUnit)(dataTimeRange))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "danger",
    hasShadow: false,
    paddingSize: "s",
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    direction: "column",
    style: {
      minHeight: '100%'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "default",
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 21
    }
  }, _i18n.i18n.translate('xpack.slo.burnRateRule.alertDetailsAppSection.burnRate.thresholdBreachedTitle', {
    defaultMessage: 'Threshold breached'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "warning",
    style: {
      marginLeft: '4px'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 23
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    title: `${(0, _numeral.default)(burnRate).format('0.[00]')}x`,
    titleColor: "default",
    titleSize: "s",
    textAlign: "right",
    isLoading: isLoading,
    "data-test-subj": "burnRateStat",
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "default",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 25
      }
    }, _i18n.i18n.translate('xpack.slo.burnRateRule.alertDetailsAppSection.burnRate.tresholdSubtitle', {
      defaultMessage: 'Alert when > {threshold}x',
      values: {
        threshold: (0, _numeral.default)(actionGroupWindow.burnRateThreshold).format('0.[00]')
      }
    }))),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 19
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 5,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_error_rate_chart.ErrorRateChart, {
    slo: slo,
    dataTimeRange: dataTimeRange,
    alertTimeRange: alertTimeRange,
    threshold: actionGroupWindow.burnRateThreshold,
    variant: "danger",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 13
    }
  })))));
}