"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.configSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _unused_urls_task = require("./unused_urls_task");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const configSchema = exports.configSchema = _configSchema.schema.object({
  new_version: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: false
    })
  }),
  url_expiration: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: false
    }),
    duration: _configSchema.schema.duration({
      defaultValue: _unused_urls_task.DEFAULT_URL_EXPIRATION_DURATION
    }),
    check_interval: _configSchema.schema.duration({
      defaultValue: _unused_urls_task.DEFAULT_URL_EXPIRATION_CHECK_INTERVAL
    }),
    url_limit: _configSchema.schema.number({
      defaultValue: _unused_urls_task.DEFAULT_URL_LIMIT
    })
  })
});