"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAiNavigationTree = void 0;
var _i18n = require("@kbn/i18n");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _navigation_tree = require("@kbn/security-solution-navigation/navigation_tree");
var _links = require("@kbn/security-solution-navigation/links");
var _icon = require("./icon");
var _stack_management_navigation = require("../stack_management_navigation");
var _callout = require("./callout");
var _v2_ease_footer_items = require("./v2_ease_footer_items");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SOLUTION_NAME = _i18n.i18n.translate('xpack.securitySolutionServerless.aiNavigation.projectType.title', {
  defaultMessage: 'Elastic AI SOC Engine'
});
const createAiNavigationTree = () => ({
  body: [{
    type: 'navGroup',
    id: 'security_solution_ai_nav',
    title: SOLUTION_NAME,
    icon: _icon.AiNavigationIcon,
    breadcrumbStatus: 'hidden',
    defaultIsCollapsed: false,
    isCollapsible: false,
    children: [{
      id: 'ease_home',
      link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.landing),
      title: SOLUTION_NAME,
      icon: _icon.AiNavigationIcon,
      renderAs: 'home',
      sideNavVersion: 'v2'
    }, {
      id: _securitySolutionNavigation.SecurityPageName.alertSummary,
      link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.alertSummary),
      iconV2: 'warning'
    }, {
      id: _securitySolutionNavigation.SecurityPageName.attackDiscovery,
      link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.attackDiscovery),
      iconV2: 'bolt'
    }, {
      breadcrumbStatus: 'hidden',
      children: [_navigation_tree.defaultNavigationTree.cases({
        sideNavVersion: 'v1'
      }), _navigation_tree.defaultNavigationTree.cases({
        sideNavVersion: 'v2'
      }), {
        id: _securitySolutionNavigation.SecurityPageName.configurations,
        link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.configurations),
        renderAs: 'item',
        iconV2: 'controlsHorizontal',
        children: [{
          id: _securitySolutionNavigation.SecurityPageName.configurationsIntegrations,
          link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.configurationsIntegrations)
        }, {
          id: _securitySolutionNavigation.SecurityPageName.configurationsBasicRules,
          link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.configurationsBasicRules)
        }, {
          id: _securitySolutionNavigation.SecurityPageName.configurationsAiSettings,
          link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.configurationsAiSettings)
        }]
      }]
    }, {
      breadcrumbStatus: 'hidden',
      children: [{
        link: 'discover'
      }, {
        id: _securitySolutionNavigation.SecurityPageName.aiValue,
        link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.aiValue),
        iconV2: 'reporter'
      }]
    }]
  }],
  callout: [{
    type: 'navGroup',
    id: 'calloutGroup',
    defaultIsCollapsed: false,
    isCollapsible: false,
    children: [{
      renderItem: _callout.renderAiSocCallout
    }]
  }],
  footer: [{
    id: 'security_solution_ai_nav_footer',
    type: 'navGroup',
    children: [{
      id: _securitySolutionNavigation.SecurityPageName.landing,
      link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.landing),
      icon: 'launch',
      iconV2: 'launch'
    }, {
      link: 'dev_tools',
      title: _links.i18nStrings.devTools,
      icon: 'editorCodeBlock',
      iconV2: 'editorCodeBlock'
    }, ..._v2_ease_footer_items.v2EaseFooterItems, (0, _stack_management_navigation.createStackManagementNavigationTree)()]
  }]
});
exports.createAiNavigationTree = createAiNavigationTree;