"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usersRelatedHosts = void 0;
var _fp = require("lodash/fp");
var _queryRelated_hosts = require("./query.related_hosts.dsl");
var _all = require("../../hosts/all");
var _build_query = require("../../../../../utils/build_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usersRelatedHosts = exports.usersRelatedHosts = {
  buildDsl: options => (0, _queryRelated_hosts.buildRelatedHostsQuery)(options),
  parse: async (options, response, deps) => {
    const aggregations = response.rawResponse.aggregations;
    const inspect = {
      dsl: [(0, _build_query.inspectStringifyObject)((0, _queryRelated_hosts.buildRelatedHostsQuery)(options))]
    };
    if (aggregations == null) {
      return {
        ...response,
        inspect,
        totalCount: 0,
        relatedHosts: []
      };
    }
    const totalCount = (0, _fp.getOr)(0, 'aggregations.host_count.value', response.rawResponse);
    const buckets = (0, _fp.getOr)([], 'aggregations.host_data.buckets', response.rawResponse);
    const relatedHosts = buckets.map(bucket => {
      var _bucket$ip$buckets$ma, _bucket$ip;
      return {
        host: bucket.key,
        ip: (_bucket$ip$buckets$ma = (_bucket$ip = bucket.ip) === null || _bucket$ip === void 0 ? void 0 : _bucket$ip.buckets.map(ip => ip.key)) !== null && _bucket$ip$buckets$ma !== void 0 ? _bucket$ip$buckets$ma : []
      };
    }, {});
    const enhancedHosts = deps !== null && deps !== void 0 && deps.spaceId ? await addHostRiskData(relatedHosts, deps.spaceId, deps.esClient) : relatedHosts;
    return {
      ...response,
      inspect,
      totalCount,
      relatedHosts: enhancedHosts
    };
  }
};
async function addHostRiskData(relatedHosts, spaceId, esClient) {
  const hostNames = relatedHosts.map(item => item.host);
  const hostRiskData = await (0, _all.getHostRiskData)(esClient, spaceId, hostNames);
  const hostsRiskByHostName = hostRiskData === null || hostRiskData === void 0 ? void 0 : hostRiskData.hits.hits.reduce((acc, hit) => {
    var _hit$_source$host$nam, _hit$_source, _hit$_source2, _hit$_source2$host, _hit$_source2$host$ri;
    return {
      ...acc,
      [(_hit$_source$host$nam = (_hit$_source = hit._source) === null || _hit$_source === void 0 ? void 0 : _hit$_source.host.name) !== null && _hit$_source$host$nam !== void 0 ? _hit$_source$host$nam : '']: (_hit$_source2 = hit._source) === null || _hit$_source2 === void 0 ? void 0 : (_hit$_source2$host = _hit$_source2.host) === null || _hit$_source2$host === void 0 ? void 0 : (_hit$_source2$host$ri = _hit$_source2$host.risk) === null || _hit$_source2$host$ri === void 0 ? void 0 : _hit$_source2$host$ri.calculated_level
    };
  }, {});
  return hostsRiskByHostName ? relatedHosts.map(item => ({
    ...item,
    risk: hostsRiskByHostName[item.host]
  })) : relatedHosts;
}