"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProductFeaturesService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _product_features = require("@kbn/security-solution-features/product_features");
var _actions = require("@kbn/security-solution-features/actions");
var _product_features2 = require("./product_features");
var _cases_product_feature_params = require("./cases_product_feature_params");
var _security_saved_objects = require("./security_saved_objects");
var _product_features_api_access_control = require("./product_features_api_access_control");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ProductFeaturesService {
  constructor(loggerFactory, experimentalFeatures) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "productFeaturesRegistry", void 0);
    (0, _defineProperty2.default)(this, "enabledProductFeatures", void 0);
    /** Function to get the correct API action name for a specific api privilege */
    (0, _defineProperty2.default)(this, "getApiActionName", apiPrivilege => `api:${_actions.API_ACTION_PREFIX}${apiPrivilege}`);
    this.logger = loggerFactory.get('productFeaturesService');
    this.productFeaturesRegistry = new _product_features2.ProductFeatures(this.logger);
    const securityFeatureParams = {
      experimentalFeatures
    };
    this.productFeaturesRegistry.create('security', [(0, _product_features.getSecurityFeature)({
      ...securityFeatureParams,
      savedObjects: _security_saved_objects.securityV1SavedObjects
    }), (0, _product_features.getSecurityV2Feature)({
      ...securityFeatureParams,
      savedObjects: _security_saved_objects.securityDefaultSavedObjects
    }), (0, _product_features.getSecurityV3Feature)({
      ...securityFeatureParams,
      savedObjects: _security_saved_objects.securityDefaultSavedObjects
    }), (0, _product_features.getSecurityV4Feature)({
      ...securityFeatureParams,
      savedObjects: _security_saved_objects.securityDefaultSavedObjects
    })]);
    this.productFeaturesRegistry.create('cases', [(0, _product_features.getCasesFeature)(_cases_product_feature_params.casesProductFeatureParams), (0, _product_features.getCasesV2Feature)(_cases_product_feature_params.casesProductFeatureParams), (0, _product_features.getCasesV3Feature)(_cases_product_feature_params.casesProductFeatureParams)]);
    this.productFeaturesRegistry.create('securityAssistant', [(0, _product_features.getAssistantFeature)(experimentalFeatures)]);
    this.productFeaturesRegistry.create('attackDiscovery', [(0, _product_features.getAttackDiscoveryFeature)(experimentalFeatures)]);
    this.productFeaturesRegistry.create('timeline', [(0, _product_features.getTimelineFeature)({
      ...securityFeatureParams,
      savedObjects: _security_saved_objects.securityTimelineSavedObjects
    })]);
    this.productFeaturesRegistry.create('notes', [(0, _product_features.getNotesFeature)({
      ...securityFeatureParams,
      savedObjects: _security_saved_objects.securityNotesSavedObjects
    })]);
    if (!experimentalFeatures.siemMigrationsDisabled) {
      this.productFeaturesRegistry.create('siemMigrations', [(0, _product_features.getSiemMigrationsFeature)()]);
    }
  }

  /** Initializes the features plugin setup */
  setup(core, plugins) {
    this.productFeaturesRegistry.init(plugins.features);
    (0, _product_features_api_access_control.registerApiAccessControl)(this, core.http);
  }

  /** Merges configurations of all the product features and registers them as Kibana features */
  setProductFeaturesConfigurator(configurator) {
    const {
      enabledProductFeatureKeys,
      extensions
    } = configurator;
    this.logger.debug(`Registering product features: ${enabledProductFeatureKeys.join(', ')}`);
    this.productFeaturesRegistry.register(enabledProductFeatureKeys, extensions);
    this.enabledProductFeatures = new Set(enabledProductFeatureKeys);
  }

  /** Function to check if a specific product feature key is enabled */
  isEnabled(productFeatureKey) {
    if (!this.enabledProductFeatures) {
      throw new Error('ProductFeatures has not yet been configured');
    }
    return this.enabledProductFeatures.has(productFeatureKey);
  }

  /** Function to check if a specific privilege action has been registered in the Kibana features */
  isActionRegistered(action) {
    return this.productFeaturesRegistry.isActionRegistered(action);
  }
}
exports.ProductFeaturesService = ProductFeaturesService;