"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildRiskScoreServiceForRequest = buildRiskScoreServiceForRequest;
var _asset_criticality = require("../../asset_criticality");
var _risk_score_service = require("../risk_score_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function buildRiskScoreServiceForRequest(securityContext, coreContext, logger) {
  const esClient = coreContext.elasticsearch.client.asCurrentUser;
  const spaceId = securityContext.getSpaceId();
  const assetCriticalityDataClient = securityContext.getAssetCriticalityDataClient();
  const assetCriticalityService = (0, _asset_criticality.assetCriticalityServiceFactory)({
    assetCriticalityDataClient,
    uiSettingsClient: coreContext.uiSettings.client
  });
  const riskEngineDataClient = securityContext.getRiskEngineDataClient();
  const riskScoreDataClient = securityContext.getRiskScoreDataClient();
  const experimentalFeatures = securityContext.getConfig().experimentalFeatures;
  const uiSettingsClient = coreContext.uiSettings.client;
  return (0, _risk_score_service.riskScoreServiceFactory)({
    assetCriticalityService,
    esClient,
    logger,
    riskEngineDataClient,
    riskScoreDataClient,
    spaceId,
    experimentalFeatures,
    uiSettingsClient
  });
}