"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.riskScoreEntityCalculationRoute = exports.deprecatedRiskScoreEntityCalculationRoute = void 0;
var _fp = require("lodash/fp");
var _utils = require("@kbn/lists-plugin/server/routes/utils");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _zodHelpers = require("@kbn/zod-helpers");
var _entity_analytics = require("../../../../../common/api/entity_analytics");
var _constants = require("../../../../../common/constants");
var _get_risk_inputs_index = require("../get_risk_inputs_index");
var _audit = require("../audit");
var _audit2 = require("../../audit");
var _helpers = require("../tasks/helpers");
var _helpers2 = require("./helpers");
var _helpers3 = require("../helpers");
var _risk_engine_privileges = require("../../risk_engine/risk_engine_privileges");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const handler = logger => async (context, request, response) => {
  var _securityContext$getA;
  const securityContext = await context.securitySolution;
  (_securityContext$getA = securityContext.getAuditLogger()) === null || _securityContext$getA === void 0 ? void 0 : _securityContext$getA.log({
    message: 'User triggered custom manual scoring',
    event: {
      action: _audit.RiskScoreAuditActions.RISK_ENGINE_ENTITY_MANUAL_SCORING,
      category: _audit2.AUDIT_CATEGORY.DATABASE,
      type: _audit2.AUDIT_TYPE.CHANGE,
      outcome: _audit2.AUDIT_OUTCOME.UNKNOWN
    }
  });
  const coreContext = await context.core;
  const securityConfig = await securityContext.getConfig();
  const siemResponse = (0, _utils.buildSiemResponse)(response);
  const soClient = coreContext.savedObjects.client;
  const riskScoreService = (0, _helpers2.buildRiskScoreServiceForRequest)(securityContext, coreContext, logger);
  const {
    identifier_type: identifierType,
    identifier,
    refresh
  } = request.body;
  try {
    var _result$scores, _result$scores$identi;
    const entityAnalyticsConfig = await riskScoreService.getConfigurationWithDefaults(securityConfig.entityAnalytics);
    if (entityAnalyticsConfig == null) {
      return siemResponse.error({
        statusCode: 400,
        body: 'No Risk engine configuration found'
      });
    }
    const {
      dataViewId,
      enabled,
      range: configuredRange,
      pageSize,
      alertSampleSizePerShard,
      filter: userFilter,
      excludeAlertStatuses,
      excludeAlertTags
    } = entityAnalyticsConfig;
    if (!enabled) {
      return siemResponse.error({
        statusCode: 400,
        body: 'Risk engine is disabled'
      });
    }
    const {
      index,
      runtimeMappings
    } = await (0, _get_risk_inputs_index.getRiskInputsIndex)({
      dataViewId,
      logger,
      soClient
    });
    const range = (0, _helpers.convertRangeToISO)(configuredRange);
    const afterKeys = {};
    const identifierFilter = {
      term: {
        [(0, _helpers3.getFieldForIdentifier)(identifierType)]: identifier
      }
    };
    const filter = (0, _fp.isEmpty)(userFilter) ? [identifierFilter] : [userFilter, identifierFilter];
    const result = await riskScoreService.calculateAndPersistScores({
      pageSize,
      identifierType: identifierType,
      index,
      filter: {
        bool: {
          filter
        }
      },
      range,
      runtimeMappings,
      weights: [],
      alertSampleSizePerShard,
      excludeAlertStatuses,
      excludeAlertTags,
      afterKeys,
      returnScores: true,
      refresh
    });
    if (result.errors.length) {
      return siemResponse.error({
        statusCode: 500,
        body: {
          message: 'Error calculating the risk score for an entity.',
          full_error: JSON.stringify(result.errors)
        },
        bypassErrorFormat: true
      });
    }
    if (result.scores_written > 0) {
      await riskScoreService.scheduleLatestTransformNow();
    }
    const score = result.scores_written === 1 ? (_result$scores = result.scores) === null || _result$scores === void 0 ? void 0 : (_result$scores$identi = _result$scores[identifierType]) === null || _result$scores$identi === void 0 ? void 0 : _result$scores$identi[0] : undefined;
    return response.ok({
      body: {
        success: true,
        score
      }
    });
  } catch (e) {
    const error = (0, _securitysolutionEsUtils.transformError)(e);
    return siemResponse.error({
      statusCode: error.statusCode,
      body: {
        message: error.message,
        full_error: JSON.stringify(e)
      },
      bypassErrorFormat: true
    });
  }
};

/**
 * @deprecated
 * It will be deleted on a future Serverless release.
 */
const deprecatedRiskScoreEntityCalculationRoute = (router, getStartServices, logger) => {
  router.versioned.post({
    path: '/api/risk_scores/calculation/entity',
    access: 'internal',
    security: {
      authz: {
        requiredPrivileges: ['securitySolution', `${_constants.APP_ID}-entity-analytics`]
      }
    }
  }).addVersion({
    version: '1',
    validate: {
      request: {
        body: (0, _zodHelpers.buildRouteValidationWithZod)(_entity_analytics.RiskScoresEntityCalculationRequest)
      }
    }
  }, (0, _risk_engine_privileges.withRiskEnginePrivilegeCheck)(getStartServices, handler(logger)));
};
exports.deprecatedRiskScoreEntityCalculationRoute = deprecatedRiskScoreEntityCalculationRoute;
const riskScoreEntityCalculationRoute = (router, getStartServices, logger) => {
  router.versioned.post({
    path: _constants.RISK_SCORE_ENTITY_CALCULATION_URL,
    access: 'internal',
    security: {
      authz: {
        requiredPrivileges: ['securitySolution', `${_constants.APP_ID}-entity-analytics`]
      }
    }
  }).addVersion({
    version: '1',
    validate: {
      request: {
        body: (0, _zodHelpers.buildRouteValidationWithZod)(_entity_analytics.RiskScoresEntityCalculationRequest)
      }
    }
  }, (0, _risk_engine_privileges.withRiskEnginePrivilegeCheck)(getStartServices, handler(logger)));
};
exports.riskScoreEntityCalculationRoute = riskScoreEntityCalculationRoute;