"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEntitiesIndexName = exports.getByEntityTypeQuery = exports.buildIndexPatternsByEngine = exports.buildIndexPatterns = exports.buildEntityDefinitionId = void 0;
exports.getEntitiesResetIndexName = getEntitiesResetIndexName;
exports.getEntitiesSnapshotIndexName = getEntitiesSnapshotIndexName;
exports.getEntitiesSnapshotIndexPattern = getEntitiesSnapshotIndexPattern;
exports.mergeEntityStoreIndices = exports.isPromiseRejected = exports.isPromiseFulfilled = exports.getEntityUpdatesIndexPatterns = void 0;
var _entitiesSchema = require("@kbn/entities-schema");
var _fp = require("lodash/fp");
var _risk_engine = require("../../../../../common/entity_analytics/risk_engine");
var _asset_criticality = require("../../../../../common/entity_analytics/asset_criticality");
var _common = require("../../../../../common/api/entity_analytics/entity_store/common.gen");
var _saved_object = require("../saved_object");
var _updates_entity_data_stream = require("../elasticsearch_assets/updates_entity_data_stream");
var _utils = require("../../../../../common/entity_analytics/privileged_user_monitoring/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildIndexPatterns = async (space, appClient, dataViewsService, onlyForType) => {
  const {
    alertsIndex,
    securitySolutionDataViewIndices
  } = await getSecuritySolutionIndices(appClient, dataViewsService);
  return [...securitySolutionDataViewIndices.filter(item => item !== alertsIndex), ...(onlyForType === 'user' ? [(0, _utils.getPrivilegedMonitorUsersIndex)(space)] : []), (0, _asset_criticality.getAssetCriticalityIndex)(space), (0, _risk_engine.getRiskScoreLatestIndex)(space)];
};
exports.buildIndexPatterns = buildIndexPatterns;
const buildIndexPatternsByEngine = async (space, entityType, appClient, dataViewsService) => {
  const patterns = await buildIndexPatterns(space, appClient, dataViewsService, entityType);
  patterns.push(getEntitiesResetIndexName(entityType, space).concat('*'));
  patterns.push(...getEntityUpdatesIndexPatterns(space, entityType));
  return patterns;
};
exports.buildIndexPatternsByEngine = buildIndexPatternsByEngine;
const getSecuritySolutionIndices = async (appClient, dataViewsService) => {
  const securitySolutionDataViewId = appClient.getSourcererDataViewId();
  let dataView;
  try {
    dataView = await dataViewsService.get(securitySolutionDataViewId);
  } catch (e) {
    if (e.isBoom && e.output.statusCode === 404) {
      throw new Error(`Data view not found '${securitySolutionDataViewId}'`);
    }
    throw e;
  }
  const dataViewIndexPattern = dataView.getIndexPattern();
  return {
    securitySolutionDataViewIndices: dataViewIndexPattern.split(','),
    alertsIndex: appClient.getAlertsIndex()
  };
};
const getByEntityTypeQuery = entityType => {
  return `${_saved_object.entityEngineDescriptorTypeName}.attributes.type: ${entityType}`;
};
exports.getByEntityTypeQuery = getByEntityTypeQuery;
const getEntitiesIndexName = (entityType, namespace) => (0, _entitiesSchema.entitiesIndexPattern)({
  schemaVersion: _entitiesSchema.ENTITY_SCHEMA_VERSION_V1,
  dataset: _entitiesSchema.ENTITY_LATEST,
  definitionId: buildEntityDefinitionId(entityType, namespace)
});
exports.getEntitiesIndexName = getEntitiesIndexName;
function getEntitiesSnapshotIndexName(entityType, snapshotDate, namespace) {
  const snapshotId = `${snapshotDate.toISOString().split('T')[0]}.${buildEntityDefinitionId(entityType, namespace)}`;
  return (0, _entitiesSchema.entitiesIndexPattern)({
    schemaVersion: _entitiesSchema.ENTITY_SCHEMA_VERSION_V1,
    dataset: _entitiesSchema.ENTITY_HISTORY,
    definitionId: snapshotId
  });
}
function getEntitiesSnapshotIndexPattern(entityType, namespace) {
  const snapshotId = `*.${buildEntityDefinitionId(entityType, namespace)}`;
  return (0, _entitiesSchema.entitiesIndexPattern)({
    schemaVersion: _entitiesSchema.ENTITY_SCHEMA_VERSION_V1,
    dataset: _entitiesSchema.ENTITY_HISTORY,
    definitionId: snapshotId
  });
}
function getEntitiesResetIndexName(entityType, namespace) {
  return (0, _entitiesSchema.entitiesIndexPattern)({
    schemaVersion: _entitiesSchema.ENTITY_SCHEMA_VERSION_V1,
    dataset: _entitiesSchema.ENTITY_RESET,
    definitionId: buildEntityDefinitionId(entityType, namespace)
  });
}
const getEntityUpdatesIndexPatterns = (space, onlyForType) => {
  const types = onlyForType ? [onlyForType] : Object.values(_common.EntityType.enum);
  const patterns = [];
  for (let i = 0; i < types.length; i++) {
    const index = (0, _updates_entity_data_stream.getEntityUpdatesDataStreamName)(types[i], space);
    patterns.push(`${index}*`);
  }
  return patterns;
};
exports.getEntityUpdatesIndexPatterns = getEntityUpdatesIndexPatterns;
const buildEntityDefinitionId = (entityType, space) => {
  return `security_${entityType}_${space}`;
};
exports.buildEntityDefinitionId = buildEntityDefinitionId;
const isPromiseFulfilled = result => result.status === 'fulfilled';
exports.isPromiseFulfilled = isPromiseFulfilled;
const isPromiseRejected = result => result.status === 'rejected';
exports.isPromiseRejected = isPromiseRejected;
const mergeEntityStoreIndices = (indices, indexPattern) => indexPattern ? (0, _fp.uniq)(indices.concat(indexPattern.split(','))) : indices;
exports.mergeEntityStoreIndices = mergeEntityStoreIndices;