"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logEqlRequest = void 0;
var _lodash = require("lodash");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QUERY_FIELDS = ['allow_no_indices', 'allow_partial_sequence_results', 'expand_wildcards', 'ignore_unavailable', 'keep_alive', 'keep_on_completion', 'wait_for_completion_timeout'];
const logEqlRequest = searchRequest => {
  const params = {
    ...(0, _lodash.pick)(searchRequest, QUERY_FIELDS),
    ...searchRequest.querystring
  };
  const body = {
    ...(0, _lodash.omit)(searchRequest, [...QUERY_FIELDS, 'index', 'querystring', 'body']),
    ...searchRequest.body
  };
  return `POST /${searchRequest.index}/_eql/search${(0, _utils.convertToQueryString)(params)}\n${JSON.stringify(body, null, 2)}`;
};
exports.logEqlRequest = logEqlRequest;