"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.enrichSignalThreatMatchesFromSignalsMap = exports.buildEnrichments = exports.MAX_NUMBER_OF_SIGNAL_MATCHES = void 0;
var _lodash = require("lodash");
var _constants = require("../../../../../../common/cti/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_NUMBER_OF_SIGNAL_MATCHES = exports.MAX_NUMBER_OF_SIGNAL_MATCHES = 200;
const buildEnrichments = ({
  hitsAndQueries,
  indicatorPath,
  threatMappings
}) => hitsAndQueries.flatMap(hitAndQuery => {
  var _get, _flat$;
  const {
    threatHit,
    query
  } = hitAndQuery;
  const indicatorValue = (0, _lodash.get)(threatHit === null || threatHit === void 0 ? void 0 : threatHit._source, indicatorPath);
  const feedName = (_get = (0, _lodash.get)(threatHit === null || threatHit === void 0 ? void 0 : threatHit._source, _constants.FEED_NAME_PATH)) !== null && _get !== void 0 ? _get : '';
  const indicator = (_flat$ = [indicatorValue].flat()[0]) !== null && _flat$ !== void 0 ? _flat$ : {};
  if (!(0, _lodash.isObject)(indicator)) {
    throw new Error(`Expected indicator field to be an object, but found: ${indicator}`);
  }
  const feed = {};
  if (feedName) {
    feed.name = feedName;
  }
  const filteredEntries = threatMappings[query.threatMappingIndex].entries.filter(entry => entry.negate !== true);
  const dedupedThreatMappingEntries = filteredEntries.reduce((accum, entry) => {
    if (!accum.some(addedEntry => (0, _lodash.isEqual)(addedEntry, entry))) {
      accum.push(entry);
    }
    return accum;
  }, []);
  return dedupedThreatMappingEntries.map(entry => ({
    indicator,
    feed,
    matched: {
      atomic: undefined,
      field: entry.field,
      // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
      id: threatHit._id,
      index: threatHit._index,
      type: _constants.ENRICHMENT_TYPES.IndicatorMatchRule
    }
  }));
});
exports.buildEnrichments = buildEnrichments;
const enrichSignalWithThreatMatches = (signalHit, enrichmentsWithoutAtomic) => {
  var _get2, _get3;
  const threat = (_get2 = (0, _lodash.get)(signalHit._source, 'threat')) !== null && _get2 !== void 0 ? _get2 : {};
  if (!(0, _lodash.isObject)(threat)) {
    throw new Error(`Expected threat field to be an object, but found: ${threat}`);
  }
  // We are not using ENRICHMENT_DESTINATION_PATH here because the code above
  // and below make assumptions about its current value, 'threat.enrichments',
  // and making this code dynamic on an arbitrary path would introduce several
  // new issues.
  const existingEnrichmentValue = (_get3 = (0, _lodash.get)(signalHit._source, 'threat.enrichments')) !== null && _get3 !== void 0 ? _get3 : [];
  const existingEnrichments = [existingEnrichmentValue].flat(); // ensure enrichments is an array
  const newEnrichments = enrichmentsWithoutAtomic.map(enrichment => ({
    ...enrichment,
    matched: {
      ...enrichment.matched,
      atomic: (0, _lodash.get)(signalHit._source, enrichment.matched.field)
    }
  }));
  return {
    ...signalHit,
    _source: {
      ...signalHit._source,
      threat: {
        ...threat,
        enrichments: [...existingEnrichments, ...newEnrichments]
      }
    }
  };
};

/**
 * enrich signals threat matches using signalsMap(Map<string, ThreatMatchNamedQuery[]>) that has match named query results
 */
const enrichSignalThreatMatchesFromSignalsMap = async (signals, indicatorPath, signalIdToMatchedQueriesMap, threatMappings) => {
  if (signals.length === 0) {
    return [];
  }
  const enrichedSignals = signals.map(signal => {
    var _signalIdToMatchedQue;
    const enrichmentsForSignal = buildEnrichments({
      indicatorPath,
      // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
      hitsAndQueries: (_signalIdToMatchedQue = signalIdToMatchedQueriesMap.get(signal._id)) !== null && _signalIdToMatchedQue !== void 0 ? _signalIdToMatchedQue : [],
      threatMappings
    });
    return enrichSignalWithThreatMatches(signal, enrichmentsForSignal);
  });
  return enrichedSignals;
};
exports.enrichSignalThreatMatchesFromSignalsMap = enrichSignalThreatMatchesFromSignalsMap;