"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.revertPrebuiltRule = void 0;
var _convert_alerting_rule_to_rule_response = require("../converters/convert_alerting_rule_to_rule_response");
var _convert_rule_response_to_alerting_rule = require("../converters/convert_rule_response_to_alerting_rule");
var _apply_rule_update = require("../mergers/apply_rule_update");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const revertPrebuiltRule = async ({
  actionsClient,
  rulesClient,
  ruleAsset,
  mlAuthz,
  existingRule,
  prebuiltRuleAssetClient
}) => {
  await (0, _utils.validateMlAuth)(mlAuthz, ruleAsset.type);
  const updatedRule = await (0, _apply_rule_update.applyRuleUpdate)({
    prebuiltRuleAssetClient,
    existingRule,
    ruleUpdate: ruleAsset
  });

  // We want to preserve existing actions from existing rule on upgrade
  if (existingRule.actions.length) {
    updatedRule.actions = existingRule.actions;
  }
  const updatedRuleWithMergedExceptions = (0, _utils.mergeExceptionLists)(updatedRule, existingRule);
  const updatedInternalRule = await rulesClient.update({
    id: existingRule.id,
    data: (0, _convert_rule_response_to_alerting_rule.convertRuleResponseToAlertingRule)(updatedRuleWithMergedExceptions, actionsClient)
  });
  return (0, _convert_alerting_rule_to_rule_response.convertAlertingRuleToRuleResponse)(updatedInternalRule);
};
exports.revertPrebuiltRule = revertPrebuiltRule;