"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SystemGenericFileLine = exports.SystemGenericFileDetails = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _draggables = require("../../../../../../common/components/draggables");
var _helpers = require("../../../../../../common/components/tables/helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _netflow = require("../netflow");
var _user_host_working_dir = require("../user_host_working_dir");
var _helpers2 = require("../helpers");
var _process_draggable = require("../process_draggable");
var _args = require("../args");
var _auth_ssh = require("./auth_ssh");
var _exit_code_draggable = require("../exit_code_draggable");
var _file_draggable = require("../file_draggable");
var _file_hash = require("../file_hash");
var _package = require("./package");
var _page = require("../../../../../../common/components/page");
var _parent_process_draggable = require("../parent_process_draggable");
var _process_hash = require("../process_hash");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/body/renderers/system/generic_file_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SystemGenericFileLine = exports.SystemGenericFileLine = /*#__PURE__*/_react.default.memo(({
  args,
  contextId,
  endgameExitCode,
  endgameFileName,
  endgameFilePath,
  endgameParentProcessName,
  endgamePid,
  endgameProcessName,
  eventAction,
  fileExtOriginalPath,
  fileHashSha256,
  fileName,
  filePath,
  hostName,
  id,
  message,
  outcome,
  packageName,
  processParentName,
  processParentPid,
  processExitCode,
  packageSummary,
  packageVersion,
  processExecutable,
  processHashSha256,
  processName,
  processPid,
  processPpid,
  processTitle,
  showMessage,
  skipRedundantFileDetails = false,
  skipRedundantProcessDetails = false,
  sshSignature,
  sshMethod,
  text,
  userDomain,
  userName,
  workingDirectory,
  scopeId
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  justifyContent: "center",
  gutterSize: "none",
  wrap: true,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 116,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_user_host_working_dir.UserHostWorkingDir, {
  eventId: id,
  contextId: contextId,
  userDomain: userDomain,
  userName: userName,
  workingDirectory: workingDirectory,
  hostName: hostName,
  scopeId: scopeId,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 117,
    columnNumber: 9
  }
}), /*#__PURE__*/_react.default.createElement(_helpers2.TokensFlexItem, {
  grow: false,
  component: "span",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 126,
    columnNumber: 9
  }
}, text), !skipRedundantFileDetails && /*#__PURE__*/_react.default.createElement(_file_draggable.FileDraggable, {
  contextId: contextId,
  endgameFileName: endgameFileName,
  endgameFilePath: endgameFilePath,
  eventId: id,
  fileExtOriginalPath: fileExtOriginalPath,
  fileName: fileName,
  filePath: filePath,
  scopeId: scopeId,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 131,
    columnNumber: 11
  }
}), (0, _helpers2.showVia)(eventAction) && /*#__PURE__*/_react.default.createElement(_helpers2.TokensFlexItem, {
  "data-test-subj": "via",
  grow: false,
  component: "span",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 143,
    columnNumber: 11
  }
}, i18n.VIA), /*#__PURE__*/_react.default.createElement(_helpers2.TokensFlexItem, {
  grow: false,
  component: "span",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 147,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_process_draggable.ProcessDraggableWithNonExistentProcess, {
  contextId: contextId,
  endgamePid: endgamePid,
  endgameProcessName: endgameProcessName,
  eventId: id,
  processPid: processPid,
  processName: processName,
  processExecutable: processExecutable,
  scopeId: scopeId,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 148,
    columnNumber: 11
  }
})), /*#__PURE__*/_react.default.createElement(_args.Args, {
  scopeId: scopeId,
  args: args,
  contextId: contextId,
  eventId: id,
  processTitle: processTitle,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 159,
    columnNumber: 9
  }
}), /*#__PURE__*/_react.default.createElement(_exit_code_draggable.ExitCodeDraggable, {
  scopeId: scopeId,
  contextId: contextId,
  endgameExitCode: endgameExitCode,
  eventId: id,
  processExitCode: processExitCode,
  text: i18n.WITH_EXIT_CODE,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 166,
    columnNumber: 9
  }
}), !(0, _helpers2.isProcessStoppedOrTerminationEvent)(eventAction) && /*#__PURE__*/_react.default.createElement(_parent_process_draggable.ParentProcessDraggable, {
  scopeId: scopeId,
  contextId: contextId,
  endgameParentProcessName: endgameParentProcessName,
  eventId: id,
  processParentName: processParentName,
  processParentPid: processParentPid,
  processPpid: processPpid,
  text: i18n.VIA_PARENT_PROCESS,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 175,
    columnNumber: 11
  }
}), outcome != null && /*#__PURE__*/_react.default.createElement(_helpers2.TokensFlexItem, {
  grow: false,
  component: "span",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 187,
    columnNumber: 11
  }
}, i18n.WITH_RESULT), /*#__PURE__*/_react.default.createElement(_helpers2.TokensFlexItem, {
  grow: false,
  component: "span",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 191,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
  scopeId: scopeId,
  contextId: contextId,
  eventId: id,
  field: "event.outcome",
  queryValue: outcome,
  value: outcome,
  isAggregatable: true,
  fieldType: "keyword",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 192,
    columnNumber: 11
  }
})), /*#__PURE__*/_react.default.createElement(_auth_ssh.AuthSsh, {
  scopeId: scopeId,
  contextId: contextId,
  eventId: id,
  sshSignature: sshSignature,
  sshMethod: sshMethod,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 203,
    columnNumber: 9
  }
}), /*#__PURE__*/_react.default.createElement(_package.Package, {
  scopeId: scopeId,
  contextId: contextId,
  eventId: id,
  packageName: packageName,
  packageSummary: packageSummary,
  packageVersion: packageVersion,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 210,
    columnNumber: 9
  }
})), !skipRedundantFileDetails && /*#__PURE__*/_react.default.createElement(_file_hash.FileHash, {
  scopeId: scopeId,
  contextId: contextId,
  eventId: id,
  fileHashSha256: fileHashSha256,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 220,
    columnNumber: 9
  }
}), !skipRedundantProcessDetails && /*#__PURE__*/_react.default.createElement(_process_hash.ProcessHash, {
  scopeId: scopeId,
  contextId: contextId,
  eventId: id,
  processHashSha256: processHashSha256,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 228,
    columnNumber: 9
  }
}), message != null && showMessage && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "xs",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 238,
    columnNumber: 11
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  justifyContent: "center",
  gutterSize: "none",
  wrap: true,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 239,
    columnNumber: 11
  }
}, /*#__PURE__*/_react.default.createElement(_helpers2.TokensFlexItem, {
  grow: false,
  component: "span",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 240,
    columnNumber: 13
  }
}, /*#__PURE__*/_react.default.createElement(_page.Badge, {
  iconType: "editorComment",
  color: "hollow",
  title: "",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 241,
    columnNumber: 15
  }
}, /*#__PURE__*/_react.default.createElement(_helpers.OverflowField, {
  value: message,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 242,
    columnNumber: 17
  }
})))))));
SystemGenericFileLine.displayName = 'SystemGenericFileLine';
const SystemGenericFileDetails = exports.SystemGenericFileDetails = /*#__PURE__*/_react.default.memo(({
  contextId,
  data,
  showMessage = true,
  skipRedundantFileDetails = false,
  skipRedundantProcessDetails = false,
  text,
  scopeId
}) => {
  const id = data._id;
  const message = data.message != null ? data.message[0] : null;
  const hostName = (0, _fp.get)('host.name[0]', data);
  const endgameExitCode = (0, _fp.get)('endgame.exit_code[0]', data);
  const endgameFileName = (0, _fp.get)('endgame.file_name[0]', data);
  const endgameFilePath = (0, _fp.get)('endgame.file_path[0]', data);
  const endgameParentProcessName = (0, _fp.get)('endgame.parent_process_name[0]', data);
  const endgamePid = (0, _fp.get)('endgame.pid[0]', data);
  const endgameProcessName = (0, _fp.get)('endgame.process_name[0]', data);
  const eventAction = (0, _fp.get)('event.action[0]', data);
  const fileExtOriginalPath = (0, _fp.get)('file.Ext.original.path[0]', data);
  const fileHashSha256 = (0, _fp.get)('file.hash.sha256[0]', data);
  const fileName = (0, _fp.get)('file.name[0]', data);
  const filePath = (0, _fp.get)('file.path[0]', data);
  const userDomain = (0, _fp.get)('user.domain[0]', data);
  const userName = (0, _fp.get)('user.name[0]', data);
  const outcome = (0, _fp.get)('event.outcome[0]', data);
  const packageName = (0, _fp.get)('system.audit.package.name[0]', data);
  const packageSummary = (0, _fp.get)('system.audit.package.summary[0]', data);
  const packageVersion = (0, _fp.get)('system.audit.package.version[0]', data);
  const processExitCode = (0, _fp.get)('process.exit_code[0]', data);
  const processParentName = (0, _fp.get)('process.parent.name[0]', data);
  const processParentPid = (0, _fp.get)('process.parent.pid[0]', data);
  const processHashSha256 = (0, _fp.get)('process.hash.sha256[0]', data);
  const processPid = (0, _fp.get)('process.pid[0]', data);
  const processPpid = (0, _fp.get)('process.ppid[0]', data);
  const processName = (0, _fp.get)('process.name[0]', data);
  const sshSignature = (0, _fp.get)('system.auth.ssh.signature[0]', data);
  const sshMethod = (0, _fp.get)('system.auth.ssh.method[0]', data);
  const processExecutable = (0, _fp.get)('process.executable[0]', data);
  const processTitle = (0, _fp.get)('process.title[0]', data);
  const workingDirectory = (0, _fp.get)('process.working_directory[0]', data);
  const args = (0, _fp.get)('process.args', data);
  return /*#__PURE__*/_react.default.createElement(_helpers2.Details, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 312,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(SystemGenericFileLine, {
    id: id,
    contextId: contextId,
    text: text,
    hostName: hostName,
    endgameExitCode: endgameExitCode,
    endgameFileName: endgameFileName,
    endgameFilePath: endgameFilePath,
    endgameParentProcessName: endgameParentProcessName,
    endgamePid: endgamePid,
    endgameProcessName: endgameProcessName,
    eventAction: eventAction,
    fileExtOriginalPath: fileExtOriginalPath,
    fileHashSha256: fileHashSha256,
    fileName: fileName,
    filePath: filePath,
    userDomain: userDomain,
    userName: userName,
    message: message,
    processExitCode: processExitCode,
    processParentName: processParentName,
    processParentPid: processParentPid,
    processTitle: processTitle,
    workingDirectory: workingDirectory,
    args: args,
    packageName: packageName,
    packageSummary: packageSummary,
    packageVersion: packageVersion,
    processHashSha256: processHashSha256,
    processName: processName,
    processPid: processPid,
    processPpid: processPpid,
    processExecutable: processExecutable,
    showMessage: showMessage,
    skipRedundantFileDetails: skipRedundantFileDetails,
    skipRedundantProcessDetails: skipRedundantProcessDetails,
    sshSignature: sshSignature,
    sshMethod: sshMethod,
    outcome: outcome,
    scopeId: scopeId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 354,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_netflow.NetflowRenderer, {
    data: data,
    timelineId: scopeId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 355,
      columnNumber: 9
    }
  }));
});
SystemGenericFileDetails.displayName = 'SystemGenericFileDetails';