"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DnsRequestEventDetailsLine = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _draggables = require("../../../../../../common/components/draggables");
var _helpers = require("../helpers");
var _process_draggable = require("../process_draggable");
var _user_host_working_dir = require("../user_host_working_dir");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/body/renderers/dns/dns_request_event_details_line.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DnsRequestEventDetailsLine = exports.DnsRequestEventDetailsLine = /*#__PURE__*/_react.default.memo(({
  contextId,
  dnsQuestionName,
  dnsQuestionType,
  dnsResolvedIp,
  dnsResponseCode,
  eventCode,
  hostName,
  id,
  processExecutable,
  processName,
  processPid,
  userDomain,
  userName,
  winlogEventId,
  scopeId
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    gutterSize: "none",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_user_host_working_dir.UserHostWorkingDir, {
    scopeId: scopeId,
    contextId: contextId,
    eventId: id,
    hostName: hostName,
    userDomain: userDomain,
    userName: userName,
    workingDirectory: undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 11
    }
  }), !(0, _helpers.isNillEmptyOrNotFinite)(dnsQuestionName) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    "data-test-subj": "asked-for",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 15
    }
  }, i18n.ASKED_FOR), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    scopeId: scopeId,
    contextId: contextId,
    eventId: id,
    field: "dns.question.name",
    value: dnsQuestionName,
    isAggregatable: true,
    fieldType: "keyword",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 17
    }
  }))), !(0, _helpers.isNillEmptyOrNotFinite)(dnsQuestionType) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    "data-test-subj": "with-question-type",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 15
    }
  }, i18n.WITH_QUESTION_TYPE), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    scopeId: scopeId,
    contextId: contextId,
    eventId: id,
    field: "dns.question.type",
    value: dnsQuestionType,
    isAggregatable: true,
    fieldType: "keyword",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 17
    }
  }))), !(0, _helpers.isNillEmptyOrNotFinite)(dnsResolvedIp) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    "data-test-subj": "which-resolved-to",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 15
    }
  }, i18n.WHICH_RESOLVED_TO), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    scopeId: scopeId,
    contextId: contextId,
    eventId: id,
    field: "dns.resolved_ip",
    value: dnsResolvedIp,
    isAggregatable: true,
    fieldType: "ip",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 17
    }
  }))), !(0, _helpers.isNillEmptyOrNotFinite)(dnsResponseCode) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 15
    }
  }, '('), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    "data-test-subj": "response-code",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 15
    }
  }, i18n.RESPONSE_CODE), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    scopeId: scopeId,
    contextId: contextId,
    eventId: id,
    field: "dns.response_code",
    value: dnsResponseCode,
    isAggregatable: true,
    fieldType: "keyword",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 15
    }
  }, ')')), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 11
    }
  }, i18n.VIA), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_process_draggable.ProcessDraggableWithNonExistentProcess, {
    scopeId: scopeId,
    contextId: contextId,
    endgamePid: undefined,
    endgameProcessName: undefined,
    eventId: id,
    processPid: processPid,
    processName: processName,
    processExecutable: processExecutable,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 13
    }
  })), (!(0, _helpers.isNillEmptyOrNotFinite)(eventCode) || !(0, _helpers.isNillEmptyOrNotFinite)(winlogEventId)) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !(0, _helpers.isNillEmptyOrNotFinite)(eventCode) ? /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    scopeId: scopeId,
    contextId: contextId,
    eventId: id,
    field: "event.code",
    value: eventCode,
    isAggregatable: true,
    fieldType: "number",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 19
    }
  })) : /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    scopeId: scopeId,
    contextId: contextId,
    eventId: id,
    iconType: "logoWindows",
    field: "winlog.event_id",
    value: winlogEventId,
    isAggregatable: true,
    fieldType: "keyword",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 19
    }
  })))));
});
DnsRequestEventDetailsLine.displayName = 'DnsRequestEventDetailsLine';