"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.alertRenderer = exports.DEFAULT_CONTEXT_ID = exports.ALERT_RENDERER_FIELDS = void 0;
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _alert_field = require("./alert_field");
var _timeline = require("../../../../../../../common/api/timeline");
var _helpers = require("./helpers");
var _helpers2 = require("../helpers");
var _row_renderer = require("../row_renderer");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/body/renderers/alert_renderer/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_CONTEXT_ID = exports.DEFAULT_CONTEXT_ID = 'alert-renderer';
const ALERT_RENDERER_FIELDS = exports.ALERT_RENDERER_FIELDS = [_helpers.DESTINATION_IP, _helpers.DESTINATION_PORT, _helpers.EVENT_CATEGORY, _helpers.FILE_NAME, _helpers.HOST_NAME, _helpers.KIBANA_ALERT_RULE_NAME, _helpers.KIBANA_ALERT_SEVERITY, _helpers.PROCESS_NAME, _helpers.PROCESS_PARENT_NAME, _helpers.SOURCE_IP, _helpers.SOURCE_PORT, _helpers.USER_NAME];
const alertRenderer = exports.alertRenderer = {
  id: _timeline.RowRendererIdEnum.alert,
  isInstance: ecs => (0, _helpers.eventKindMatches)((0, _fp.get)('event.kind', ecs)),
  renderRow: ({
    contextId = DEFAULT_CONTEXT_ID,
    data,
    scopeId
  }) => {
    const eventId = (0, _fp.get)(_helpers.ID, data);
    const destinationIp = (0, _fp.get)(_helpers.DESTINATION_IP, data);
    const destinationPort = (0, _fp.get)(_helpers.DESTINATION_PORT, data);
    const eventCategory = (0, _fp.get)(_helpers.EVENT_CATEGORY, data);
    const fileName = (0, _fp.get)(_helpers.FILE_NAME, data);
    const hostName = (0, _fp.get)(_helpers.HOST_NAME, data);
    const kibanaAlertRuleName = (0, _fp.get)(_helpers.KIBANA_ALERT_RULE_NAME, data);
    const kibanaAlertSeverity = (0, _fp.get)(_helpers.KIBANA_ALERT_SEVERITY, data);
    const processName = (0, _fp.get)(_helpers.PROCESS_NAME, data);
    const processParentName = (0, _fp.get)(_helpers.PROCESS_PARENT_NAME, data);
    const sourceIp = (0, _fp.get)(_helpers.SOURCE_IP, data);
    const sourcePort = (0, _fp.get)(_helpers.SOURCE_PORT, data);
    const userName = (0, _fp.get)(_helpers.USER_NAME, data);
    return /*#__PURE__*/_react.default.createElement(_row_renderer.RowRendererContainer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_helpers2.Details, {
      "data-test-subj": "alertRenderer",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "xs",
      justifyContent: "center",
      wrap: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_alert_field.AlertField, {
      contextId: contextId,
      "data-test-subj": _helpers.EVENT_CATEGORY,
      eventId: eventId,
      field: _helpers.EVENT_CATEGORY,
      scopeId: scopeId,
      values: eventCategory,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "event",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 15
      }
    }, ` ${i18n.EVENT} `)), (0, _helpers.showWith)({
      data,
      fieldNames: _helpers.WITH_FIELD_NAMES
    }) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "with",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 17
      }
    }, ` ${i18n.WITH} `)), /*#__PURE__*/_react.default.createElement(_alert_field.AlertField, {
      contextId: contextId,
      "data-test-subj": _helpers.PROCESS_NAME,
      eventId: eventId,
      field: _helpers.PROCESS_NAME,
      prefix: ` ${i18n.PROCESS} `,
      suffix: ", ",
      scopeId: scopeId,
      values: processName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_alert_field.AlertField, {
      contextId: contextId,
      "data-test-subj": _helpers.PROCESS_PARENT_NAME,
      eventId: eventId,
      field: _helpers.PROCESS_PARENT_NAME,
      prefix: ` ${i18n.PARENT_PROCESS} `,
      suffix: ", ",
      scopeId: scopeId,
      values: processParentName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_alert_field.AlertField, {
      contextId: contextId,
      "data-test-subj": _helpers.FILE_NAME,
      eventId: eventId,
      field: _helpers.FILE_NAME,
      prefix: ` ${i18n.FILE} `,
      suffix: ", ",
      scopeId: scopeId,
      values: fileName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_alert_field.AlertField, {
      contextId: contextId,
      "data-test-subj": _helpers.SOURCE_IP,
      eventId: eventId,
      field: _helpers.SOURCE_IP,
      prefix: ` ${i18n.SOURCE} `,
      scopeId: scopeId,
      values: sourceIp,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_alert_field.AlertField, {
      contextId: contextId,
      "data-test-subj": _helpers.SOURCE_PORT,
      eventId: eventId,
      field: _helpers.SOURCE_PORT,
      prefix: ":",
      suffix: ", ",
      scopeId: scopeId,
      values: sourcePort,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_alert_field.AlertField, {
      contextId: contextId,
      "data-test-subj": _helpers.DESTINATION_IP,
      eventId: eventId,
      field: _helpers.DESTINATION_IP,
      prefix: ` ${i18n.DESTINATION} `,
      scopeId: scopeId,
      values: destinationIp,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_alert_field.AlertField, {
      contextId: contextId,
      "data-test-subj": _helpers.DESTINATION_PORT,
      eventId: eventId,
      field: _helpers.DESTINATION_PORT,
      prefix: ":",
      suffix: ", ",
      scopeId: scopeId,
      values: destinationPort,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_alert_field.AlertField, {
      contextId: contextId,
      "data-test-subj": _helpers.USER_NAME,
      eventId: eventId,
      field: _helpers.USER_NAME,
      prefix: ` ${i18n.BY} `,
      scopeId: scopeId,
      values: userName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_alert_field.AlertField, {
      contextId: contextId,
      "data-test-subj": _helpers.HOST_NAME,
      eventId: eventId,
      field: _helpers.HOST_NAME,
      prefix: ` ${i18n.ON} `,
      scopeId: scopeId,
      values: hostName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_alert_field.AlertField, {
      contextId: contextId,
      "data-test-subj": _helpers.KIBANA_ALERT_SEVERITY,
      eventId: eventId,
      field: _helpers.KIBANA_ALERT_SEVERITY,
      prefix: ` ${i18n.CREATED} `,
      suffix: ` ${i18n.ALERT} `,
      scopeId: scopeId,
      values: kibanaAlertSeverity,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 193,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_alert_field.AlertField, {
      contextId: contextId,
      "data-test-subj": _helpers.KIBANA_ALERT_RULE_NAME,
      eventId: eventId,
      field: _helpers.KIBANA_ALERT_RULE_NAME,
      suffix: ".",
      scopeId: scopeId,
      values: kibanaAlertRuleName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 204,
        columnNumber: 13
      }
    }))));
  }
};