"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateFieldButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/fields_browser/create_field_button/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledButton = (0, _styledComponents.default)(_eui.EuiButton)`
  margin-left: ${({
  theme
}) => theme.eui.euiSizeM};
`;
/**
 *
 * Returns a memoised 'CreateFieldButton' with only an 'onClick' property.
 */
const useCreateFieldButton = ({
  isAllowed,
  loading,
  openFieldEditor
}) => {
  const createFieldButton = (0, _react.useCallback)(({
    onHide
  }) => /*#__PURE__*/_react.default.createElement(StyledButton, {
    iconType: loading ? 'none' : 'plusInCircle',
    "aria-label": i18n.CREATE_FIELD,
    "data-test-subj": "create-field",
    onClick: () => {
      openFieldEditor();
      onHide();
    },
    isLoading: loading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }, i18n.CREATE_FIELD), [loading, openFieldEditor]);
  return isAllowed ? createFieldButton : undefined;
};
exports.useCreateFieldButton = useCreateFieldButton;