"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertValuesToComboboxValueArray = exports.convertComboboxValuesToStringArray = exports.ControlledComboboxInput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _helpers = require("../../timeline/helpers");
var i18n = _interopRequireWildcard(require("../translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/edit_data_provider/components/controlled_combobox_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ControlledComboboxInput = ({
  value,
  onChangeCallback
}) => {
  const [includeValues, setIncludeValues] = (0, _react.useState)(convertValuesToComboboxValueArray(value));
  (0, _react.useEffect)(() => {
    onChangeCallback(convertComboboxValuesToStringArray(includeValues));
  }, [includeValues, onChangeCallback]);
  const onCreateOption = (0, _react.useCallback)((searchValue, flattenedOptions = includeValues) => {
    const normalizedSearchValue = searchValue.trim().toLowerCase();
    if (!normalizedSearchValue) {
      return;
    }
    if (flattenedOptions.findIndex(option => option.label.trim().toLowerCase() === normalizedSearchValue) === -1
    // add the option, because it wasn't found in the current set of `includeValues`
    ) {
      setIncludeValues([...includeValues, {
        label: searchValue
      }]);
    }
  }, [includeValues]);
  const onIncludeValueChanged = (0, _react.useCallback)(updatedIncludesValues => {
    setIncludeValues(updatedIncludesValues);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    noSuggestions: true,
    isClearable: true,
    "data-test-subj": "is-one-of-combobox-input",
    selectedOptions: includeValues,
    placeholder: i18n.ENTER_ONE_OR_MORE_VALUES,
    "aria-label": i18n.ENTER_ONE_OR_MORE_VALUES,
    onCreateOption: onCreateOption,
    onChange: onIncludeValueChanged,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  });
};
exports.ControlledComboboxInput = ControlledComboboxInput;
const convertValuesToComboboxValueArray = values => (0, _helpers.isPrimitiveArray)(values) ? values.map(item => ({
  label: String(item)
})) : [];
exports.convertValuesToComboboxValueArray = convertValuesToComboboxValueArray;
const convertComboboxValuesToStringArray = values => values.map(item => item.label);
exports.convertComboboxValuesToStringArray = convertComboboxValuesToStringArray;