"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CopyToClipboardContextMenu = exports.CopyToClipboardButtonIcon = exports.CopyToClipboardButtonEmpty = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/threat_intelligence/modules/indicators/components/common/copy_to_clipboard.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const COPY_ICON = 'copyClipboard';
/**
 * Takes a string and copies it to the clipboard.
 *
 * This component renders an {@link EuiButtonEmpty}.
 *
 * @returns An EuiCopy element
 */
const CopyToClipboardButtonEmpty = ({
  value,
  'data-test-subj': dataTestSub
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
  textToCopy: value,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 37,
    columnNumber: 3
  }
}, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  "aria-label": _translations.COPY_TITLE,
  iconType: COPY_ICON,
  iconSize: "s",
  color: "primary",
  onClick: copy,
  "data-test-subj": dataTestSub,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 39,
    columnNumber: 7
  }
}, _translations.COPY_TITLE));

/**
 * Takes a string and copies it to the clipboard.
 *
 * This component is to be used in an EuiContextMenu.
 *
 * @returns filter in {@link EuiContextMenuItem} for a context menu
 */
exports.CopyToClipboardButtonEmpty = CopyToClipboardButtonEmpty;
const CopyToClipboardContextMenu = ({
  value,
  'data-test-subj': dataTestSub
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
  textToCopy: value,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 64,
    columnNumber: 3
  }
}, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
  key: "copyToClipboard",
  icon: COPY_ICON,
  size: "s",
  onClick: copy,
  "data-test-subj": dataTestSub,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 66,
    columnNumber: 7
  }
}, _translations.COPY_TITLE));

/**
 * Takes a string and copies it to the clipboard.
 *
 * This component renders an {@link EuiButtonIcon}.
 *
 * @returns An EuiCopy element
 */
exports.CopyToClipboardContextMenu = CopyToClipboardContextMenu;
const CopyToClipboardButtonIcon = ({
  value,
  'data-test-subj': dataTestSub
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
  textToCopy: value,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 90,
    columnNumber: 3
  }
}, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
  "aria-label": _translations.COPY_TITLE,
  iconType: COPY_ICON,
  iconSize: "s",
  color: "primary",
  onClick: copy,
  "data-test-subj": dataTestSub,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 92,
    columnNumber: 7
  }
}, _translations.COPY_TITLE));
exports.CopyToClipboardButtonIcon = CopyToClipboardButtonIcon;