"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReadinessTasksTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _siemReadiness = require("@kbn/siem-readiness");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _use_pillar_props = require("../hooks/use_pillar_props");
var _illustration_aerospace = _interopRequireDefault(require("../assets/illustration_aerospace.svg"));
var _illustration_packed_box = _interopRequireDefault(require("../assets/illustration_packed_box.svg"));
var _illustration_cloud_rocket = _interopRequireDefault(require("../assets/illustration_cloud_rocket.svg"));
var _illustration_monitor_cogs = _interopRequireDefault(require("../assets/illustration_monitor_cogs.svg"));
var _illustration_on_prem = _interopRequireDefault(require("../assets/illustration_on_prem.svg"));
var _illustration_cloud_cog = _interopRequireDefault(require("../assets/illustration_cloud_cog.svg"));
var _illustration_checklist_doc = _interopRequireDefault(require("../assets/illustration_checklist_doc.svg"));
var _illustration_cloud_services = _interopRequireDefault(require("../assets/illustration_cloud_services.svg"));
var _illustration_file_monitoring = _interopRequireDefault(require("../assets/illustration_file_monitoring.svg"));
var _illustration_malware_bug = _interopRequireDefault(require("../assets/illustration_malware_bug.svg"));
var _illustration_network_activity = _interopRequireDefault(require("../assets/illustration_network_activity.svg"));
var _illustration_insights_files = _interopRequireDefault(require("../assets/illustration_insights_files.svg"));
var _illustration_asset_visibility = _interopRequireDefault(require("../assets/illustration_asset_visibility.svg"));
var _illustration_magnify_glass = _interopRequireDefault(require("../assets/illustration_magnify_glass.svg"));
var _illustration_megaphone = _interopRequireDefault(require("../assets/illustration_megaphone.svg"));
var _illustration_machine_brain = _interopRequireDefault(require("../assets/illustration_machine_brain.svg"));
var _illustration_projects_folder = _interopRequireDefault(require("../assets/illustration_projects_folder.svg"));
var _illustration_right_arrows = _interopRequireDefault(require("../assets/illustration_right_arrows.svg"));
var _illustration_organize_folders = _interopRequireDefault(require("../assets/illustration_organize_folders.svg"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_readiness/pages/readiness_tasks_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// Color constants
const INCOMPLETE_BADGE_COLOR = '#FDE9B5';
const COMPLETED_BADGE_COLOR = '#4DD2CA';
const PANEL_HEIGHT = 600;
const ILLUSTRATION_SIZE = 128;
const FILTER_WIDTH = 150; // Width for longest filter label

const ReadinessTasksTable = () => {
  const [selectedPillar, setSelectedPillar] = (0, _useLocalStorage.default)('readiness-tasks-selected-pillar', '');
  const [statusFilter, setStatusFilter] = (0, _useLocalStorage.default)('readiness-tasks-status-filter', null);
  const {
    pillarPropsMap
  } = (0, _use_pillar_props.usePillarsProps)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    logReadinessTask,
    getLatestTasks
  } = (0, _siemReadiness.useReadinessTasks)();
  const handleLogTask = (0, _react.useCallback)(async task => {
    logReadinessTask(task);
  }, [logReadinessTask]);
  const selectOptions = (0, _react.useMemo)(() => [{
    value: '',
    inputDisplay: _i18n.i18n.translate('xpack.securitySolution.siemReadiness.allCategoriesOption', {
      defaultMessage: 'All Categories'
    })
  }, ...Object.values(pillarPropsMap).map(pillar => ({
    value: pillar.pillarKey,
    inputDisplay: pillar.displayName
  }))], [pillarPropsMap]);
  const filteredTasks = (0, _react.useMemo)(() => _siemReadiness.READINESS_TASKS.filter(task => !selectedPillar || task.pillar === selectedPillar).filter(task => {
    var _getLatestTasks$data;
    const taskData = (_getLatestTasks$data = getLatestTasks.data) === null || _getLatestTasks$data === void 0 ? void 0 : _getLatestTasks$data.find(latestTaskData => latestTaskData.task_id === task.id);
    if (statusFilter === 'completed') {
      return (taskData === null || taskData === void 0 ? void 0 : taskData.status) === 'completed';
    }
    if (statusFilter === 'incomplete') {
      return (taskData === null || taskData === void 0 ? void 0 : taskData.status) !== 'completed';
    }
    return true;
  }).sort((a, b) => a.order - b.order), [selectedPillar, statusFilter, getLatestTasks.data]);
  const taskCounts = (0, _react.useMemo)(() => {
    const allTasks = _siemReadiness.READINESS_TASKS.filter(task => !selectedPillar || task.pillar === selectedPillar);
    const completedCount = allTasks.filter(task => {
      var _getLatestTasks$data2;
      const taskData = (_getLatestTasks$data2 = getLatestTasks.data) === null || _getLatestTasks$data2 === void 0 ? void 0 : _getLatestTasks$data2.find(latestTaskData => latestTaskData.task_id === task.id);
      return (taskData === null || taskData === void 0 ? void 0 : taskData.status) === 'completed';
    }).length;
    const incompleteCount = allTasks.length - completedCount;
    return {
      completed: completedCount,
      incomplete: incompleteCount
    };
  }, [selectedPillar, getLatestTasks.data]);
  const readinessTasksAddOnsMap = (0, _react.useMemo)(() => ({
    'lets-get-started': {
      action: () => handleLogTask({
        task_id: 'lets-get-started',
        status: 'completed'
      }),
      actionButtonLabel: 'Complete Task',
      illustration: _illustration_aerospace.default,
      learnMoreLink: 'https://www.elastic.co/security-readiness'
    },
    'enable-endpoint-visibility': {
      action: () => handleLogTask({
        task_id: 'enable-endpoint-visibility',
        status: 'completed'
      }),
      actionButtonLabel: 'Complete Task',
      illustration: _illustration_packed_box.default
    },
    'ingest-cloud-audit-logs': {
      action: () => handleLogTask({
        task_id: 'ingest-cloud-audit-logs',
        status: 'completed'
      }),
      actionButtonLabel: 'Complete Task',
      illustration: _illustration_cloud_rocket.default
    },
    'ingest-asset-inventory': {
      action: () => handleLogTask({
        task_id: 'ingest-asset-inventory',
        status: 'completed'
      }),
      actionButtonLabel: 'Complete Task',
      illustration: _illustration_monitor_cogs.default
    },
    'enable-kubernetes-container-logs': {
      action: () => handleLogTask({
        task_id: 'enable-kubernetes-container-logs',
        status: 'completed'
      }),
      actionButtonLabel: 'Complete Task',
      illustration: _illustration_on_prem.default
    },
    'ingest-all-cloud-logs-inventory': {
      action: () => handleLogTask({
        task_id: 'ingest-all-cloud-logs-inventory',
        status: 'completed'
      }),
      actionButtonLabel: 'Complete Task',
      illustration: _illustration_cloud_cog.default
    },
    'enable-mitre-aligned-detection-rules': {
      action: () => handleLogTask({
        task_id: 'enable-mitre-aligned-detection-rules',
        status: 'completed'
      }),
      actionButtonLabel: 'Complete Task',
      illustration: _illustration_checklist_doc.default
    },
    'view-detection-coverage-mitre': {
      action: () => handleLogTask({
        task_id: 'view-detection-coverage-mitre',
        status: 'completed'
      }),
      actionButtonLabel: 'Complete Task',
      illustration: _illustration_insights_files.default
    },
    'add-threat-intel-feeds': {
      action: () => handleLogTask({
        task_id: 'add-threat-intel-feeds',
        status: 'completed'
      }),
      actionButtonLabel: 'Complete Task',
      illustration: _illustration_malware_bug.default
    },
    'customize-create-rules': {
      action: () => handleLogTask({
        task_id: 'customize-create-rules',
        status: 'completed'
      }),
      actionButtonLabel: 'Complete Task',
      illustration: _illustration_file_monitoring.default
    },
    'use-attack-discovery': {
      action: () => handleLogTask({
        task_id: 'use-attack-discovery',
        status: 'completed'
      }),
      actionButtonLabel: 'Complete Task',
      illustration: _illustration_network_activity.default
    },
    'maintain-rule-coverage': {
      action: () => handleLogTask({
        task_id: 'maintain-rule-coverage',
        status: 'completed'
      }),
      actionButtonLabel: 'Complete Task',
      illustration: _illustration_asset_visibility.default
    },
    'enable-cspm-on-all-clouds': {
      action: () => handleLogTask({
        task_id: 'enable-cspm-on-all-clouds',
        status: 'completed'
      }),
      actionButtonLabel: 'Complete Task',
      illustration: _illustration_cloud_services.default
    },
    'investigate-alert-using-timeline': {
      action: () => handleLogTask({
        task_id: 'investigate-alert-using-timeline',
        status: 'completed'
      }),
      actionButtonLabel: 'Complete Task',
      illustration: _illustration_magnify_glass.default
    },
    'use-ai-assistant-for-alert-root-cause': {
      action: () => handleLogTask({
        task_id: 'use-ai-assistant-for-alert-root-cause',
        status: 'completed'
      }),
      actionButtonLabel: 'Complete Task',
      illustration: _illustration_machine_brain.default
    },
    'add-external-connectors': {
      action: () => handleLogTask({
        task_id: 'add-external-connectors',
        status: 'completed'
      }),
      actionButtonLabel: 'Complete Task',
      illustration: _illustration_megaphone.default
    },
    'automate-response-rules-case-creation': {
      action: () => handleLogTask({
        task_id: 'automate-response-rules-case-creation',
        status: 'completed'
      }),
      actionButtonLabel: 'Complete Task',
      illustration: _illustration_right_arrows.default
    },
    'create-manage-case-workflows': {
      action: () => handleLogTask({
        task_id: 'create-manage-case-workflows',
        status: 'completed'
      }),
      actionButtonLabel: 'Complete Task',
      illustration: _illustration_projects_folder.default
    },
    'complete-automated-cases': {
      action: () => handleLogTask({
        task_id: 'complete-automated-cases',
        status: 'completed'
      }),
      actionButtonLabel: 'Complete Task',
      illustration: _illustration_organize_folders.default
    }
  }), [handleLogTask]);
  const taskStatusFilters = (0, _react.useMemo)(() => [{
    key: 'incomplete',
    label: _i18n.i18n.translate('xpack.securitySolution.siemReadiness.incompleteFilter', {
      defaultMessage: 'Incomplete'
    }),
    count: taskCounts.incomplete,
    isActive: statusFilter === 'incomplete',
    onClick: () => {
      setStatusFilter(statusFilter === 'incomplete' ? null : 'incomplete');
    },
    withNext: true
  }, {
    key: 'completed',
    label: _i18n.i18n.translate('xpack.securitySolution.siemReadiness.completeFilter', {
      defaultMessage: 'Complete'
    }),
    count: taskCounts.completed,
    isActive: statusFilter === 'completed',
    onClick: () => {
      setStatusFilter(statusFilter === 'completed' ? null : 'completed');
    },
    withNext: false
  }], [statusFilter, taskCounts.completed, taskCounts.incomplete, setStatusFilter]);
  const categoriesSelectLabel = _i18n.i18n.translate('xpack.securitySolution.siemReadiness.categoriesPlaceholder', {
    defaultMessage: 'Categories'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    hasBorder: true,
    hasShadow: false,
    css: {
      height: PANEL_HEIGHT
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 292,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    grow: false,
    css: {
      width: '100%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 297,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.securitySolution.siemReadiness.tasksTitle', {
    defaultMessage: 'Tasks'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 17
    }
  }, taskStatusFilters.map(filter => /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    key: filter.key,
    withNext: filter.withNext,
    hasActiveFilters: filter.isActive,
    isSelected: filter.isActive,
    onClick: filter.onClick,
    isToggle: true,
    "data-test-subj": `${filter.key}FilterButton`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 309,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 318,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 25
    }
  }, filter.label), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 320,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 321,
      columnNumber: 27
    }
  }, filter.count))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 330,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    css: {
      width: FILTER_WIDTH
    },
    options: selectOptions,
    valueOfSelected: selectedPillar,
    onChange: value => setSelectedPillar(value),
    placeholder: categoriesSelectLabel,
    "aria-label": categoriesSelectLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 17
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    grow: true,
    color: "subdued",
    css: {
      overflowY: 'auto'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 344,
      columnNumber: 7
    }
  }, filteredTasks.map(task => {
    var _getLatestTasks$data3;
    const taskAddOn = readinessTasksAddOnsMap[task.id] || {};
    const taskData = (_getLatestTasks$data3 = getLatestTasks.data) === null || _getLatestTasks$data3 === void 0 ? void 0 : _getLatestTasks$data3.find(latestTaskData => latestTaskData.task_id === task.id);
    const taskPillar = pillarPropsMap[task.pillar];
    return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
      css: {
        backgroundColor: euiTheme.colors.plainLight,
        margin: `${euiTheme.size.m} 0`,
        paddingRight: euiTheme.size.s
      },
      borders: "all",
      key: task.id,
      id: task.id,
      arrowDisplay: "right",
      buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        justifyContent: "spaceBetween",
        gutterSize: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 364,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 365,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement("div", {
        style: {
          display: 'flex',
          alignItems: 'center'
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 366,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        style: {
          marginRight: euiTheme.size.s,
          fontWeight: euiTheme.font.weight.bold
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 367,
          columnNumber: 23
        }
      }, _i18n.i18n.translate('xpack.securitySolution.siemReadiness.categoryLabel', {
        defaultMessage: 'Category:'
      })), (taskPillar === null || taskPillar === void 0 ? void 0 : taskPillar.icon) && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: taskPillar.icon,
        size: "m",
        color: taskPillar.color,
        css: {
          marginRight: euiTheme.size.s
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 378,
          columnNumber: 25
        }
      }), /*#__PURE__*/_react.default.createElement("span", {
        style: {
          marginRight: euiTheme.size.m
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 385,
          columnNumber: 23
        }
      }, taskPillar === null || taskPillar === void 0 ? void 0 : taskPillar.displayName), /*#__PURE__*/_react.default.createElement("span", {
        style: {
          fontWeight: euiTheme.font.weight.bold,
          marginRight: euiTheme.size.s
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 388,
          columnNumber: 23
        }
      }, _i18n.i18n.translate('xpack.securitySolution.siemReadiness.taskLabel', {
        defaultMessage: 'Task:'
      })), /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 398,
          columnNumber: 23
        }
      }, `${task.taskNumber}. ${task.title}`)))),
      paddingSize: "l",
      initialIsOpen: false,
      buttonProps: {
        paddingSize: 'm'
      },
      style: {
        borderRadius: euiTheme.border.radius.medium
      },
      extraAction: /*#__PURE__*/_react.default.createElement("div", {
        style: {
          paddingRight: euiTheme.size.base
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 412,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: (taskData === null || taskData === void 0 ? void 0 : taskData.status) === 'completed' ? COMPLETED_BADGE_COLOR : INCOMPLETE_BADGE_COLOR,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 413,
          columnNumber: 19
        }
      }, (taskData === null || taskData === void 0 ? void 0 : taskData.status) === 'completed' ? _i18n.i18n.translate('xpack.securitySolution.siemReadiness.completedStatus', {
        defaultMessage: 'Completed'
      }) : _i18n.i18n.translate('xpack.securitySolution.siemReadiness.incompleteStatus', {
        defaultMessage: 'Incomplete'
      }))),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 353,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 431,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 432,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 433,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 434,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 435,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      style: {
        whiteSpace: 'pre-wrap'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 436,
        columnNumber: 25
      }
    }, task.description))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      style: {
        justifyContent: 'flex-start',
        alignItems: 'flex-end',
        flexDirection: 'row',
        gap: euiTheme.size.s
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 439,
        columnNumber: 21
      }
    }, taskAddOn.actionButtonLabel && taskAddOn.action && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      fill: true,
      onClick: () => {
        var _taskAddOn$action;
        return (_taskAddOn$action = taskAddOn.action) === null || _taskAddOn$action === void 0 ? void 0 : _taskAddOn$action.call(taskAddOn);
      },
      disabled: (taskData === null || taskData === void 0 ? void 0 : taskData.status) === 'completed',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 448,
        columnNumber: 25
      }
    }, taskAddOn.actionButtonLabel), taskAddOn.learnMoreLink && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "popout",
      size: "s",
      onClick: () => window.open(taskAddOn.learnMoreLink, '_blank'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 458,
        columnNumber: 25
      }
    }, _i18n.i18n.translate('xpack.securitySolution.siemReadiness.learnMoreButton', {
      defaultMessage: 'Learn More'
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      css: {
        width: ILLUSTRATION_SIZE
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 471,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: taskAddOn.illustration,
      css: {
        width: ILLUSTRATION_SIZE,
        height: ILLUSTRATION_SIZE
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 472,
        columnNumber: 19
      }
    }))));
  })));
};
exports.ReadinessTasksTable = ReadinessTasksTable;