"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MigrationRulesFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _filters = require("../../../../common/components/filters");
var _components = require("../../../../common/components");
var _types = require("../../../types");
var _author = require("./author");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/rules/components/rules_table/filters/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MigrationRulesFilter = exports.MigrationRulesFilter = /*#__PURE__*/_react.default.memo(({
  filterOptions,
  onFilterOptionsChanged
}) => {
  const handleOnStatusChanged = (0, _react.useCallback)(newStatus => {
    onFilterOptionsChanged({
      ...filterOptions,
      ...{
        status: newStatus
      }
    });
  }, [filterOptions, onFilterOptionsChanged]);
  const handleOnAuthorChanged = (0, _react.useCallback)(newAuthor => {
    onFilterOptionsChanged({
      ...filterOptions,
      ...{
        author: newAuthor
      }
    });
  }, [filterOptions, onFilterOptionsChanged]);
  const statusFilterOptions = [..._filters.statusFilterBaseOptions, {
    label: i18n.INDEX_PATTERN_MISSING_FILTER_OPTION,
    data: {
      status: _types.RulesSpecificStatusFilter.INDEX_PATTERN_MISSING
    }
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_components.StatusFilterButton, {
    status: filterOptions === null || filterOptions === void 0 ? void 0 : filterOptions.status,
    onStatusChanged: handleOnStatusChanged,
    statusFilterOptions: statusFilterOptions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_author.AuthorFilterButton, {
    author: filterOptions === null || filterOptions === void 0 ? void 0 : filterOptions.author,
    onAuthorChanged: handleOnAuthorChanged,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  }));
});
MigrationRulesFilter.displayName = 'MigrationRulesFilter';