"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ValueReportSettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _react2 = require("@emotion/react");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/reports/components/ai_value/value_report_settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ValueReportSettingsComponent = ({
  minutesPerAlert,
  analystHourlyRate
}) => {
  const {
    navigateTo
  } = (0, _securitySolutionNavigation.useNavigation)();
  const {
    euiTheme: {
      size
    }
  } = (0, _eui.useEuiTheme)();
  const goToKibanaSettings = (0, _react.useCallback)(() => navigateTo({
    appId: 'management',
    path: '/kibana/settings?query=defaultValueReport'
  }), [navigateTo]);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        padding: ${size.base} ${size.xl};
      `,
    className: "valueReportSettings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 9
    }
  }, i18n.COST_CALCULATIONS)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 9
    }
  }, i18n.COST_CALCULATION({
    minutesPerAlert,
    analystHourlyRate
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: goToKibanaSettings,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 11
    }
  }, i18n.CHANGE_RATE, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "popout",
    size: "s",
    css: (0, _react2.css)`
                margin-left: 4px;
              `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 9
    }
  }, i18n.LEGAL_DISCLAIMER)));
};
const ValueReportSettings = exports.ValueReportSettings = /*#__PURE__*/_react.default.memo(ValueReportSettingsComponent);