"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertProcessingDonut = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _types = require("../../../common/components/visualization_actions/types");
var _use_space_id = require("../../../common/hooks/use_space_id");
var _alert_processing_donut = require("../../../common/components/visualization_actions/lens_attributes/ai/alert_processing_donut");
var _model = require("../../../sourcerer/store/model");
var _visualization_embeddable = require("../../../common/components/visualization_actions/visualization_embeddable");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/reports/components/ai_value/alert_processing_donut_lens.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ChartSize = 250;
const AlertProcessingDonut = ({
  attackAlertIds,
  from,
  to
}) => {
  const spaceId = (0, _use_space_id.useSpaceId)();
  const {
    euiTheme: {
      font
    }
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "donutChart",
    css: (0, _react2.css)`
        // hide filtering actions in the legend
        .echLegendItem__action {
          display: none;
        }
        .donutText {
          text-align: center;
          top: 44% !important;
          max-width: 100% !important;
          .donutTitleLabel {
            font-size: ${font.scale.m}em;
          }
          b {
            font-size: ${font.scale.xl}em;
          }
        }
        .euiPanel,
        .embPanel,
        .echMetric,
        .echChartBackground,
        .embPanel__hoverActions > span {
          background-color: rgb(0, 0, 0, 0) !important;
        }
        .donutChart .euiPanel {
          background-color: rgb(255, 255, 255, 0);
        }
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_visualization_embeddable.VisualizationEmbeddable, {
    applyGlobalQueriesAndFilters: false,
    getLensAttributes: args => (0, _alert_processing_donut.getAlertProcessingDonutAttributes)({
      ...args,
      attackAlertIds,
      spaceId: spaceId !== null && spaceId !== void 0 ? spaceId : 'default'
    }),
    height: ChartSize,
    width: '100%',
    id: `open`,
    isDonut: true,
    donutTitleLabel: 'Total alerts processed',
    donutTextWrapperClassName: 'donutText',
    scopeId: _model.SourcererScopeName.detections,
    timerange: {
      from,
      to
    },
    withActions: [_types.VisualizationContextMenuActions.addToExistingCase, _types.VisualizationContextMenuActions.addToNewCase, _types.VisualizationContextMenuActions.inspect],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }));
};
exports.AlertProcessingDonut = AlertProcessingDonut;