"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.onboardingConfig = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("./constants");
var _body_config = require("./components/onboarding_body/body_config");
var _constants2 = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const onboardingConfig = exports.onboardingConfig = [{
  id: _constants.OnboardingTopicId.default,
  title: _i18n.i18n.translate('xpack.securitySolution.onboarding.topic.default', {
    defaultMessage: 'Set up Security'
  }),
  capabilitiesRequired: `${_constants2.SECURITY_FEATURE_ID}.detections`,
  body: _body_config.defaultBodyConfig
}, {
  // The "detections" and "external_detections" capabilities are mutually exclusive, so we will always have only one `default` topic enabled at a time
  id: _constants.OnboardingTopicId.default,
  title: _i18n.i18n.translate('xpack.securitySolution.onboarding.topic.externalDetections.default', {
    defaultMessage: 'Set up Security'
  }),
  capabilitiesRequired: `${_constants2.SECURITY_FEATURE_ID}.external_detections`,
  body: _body_config.defaultExternalDetectionsBodyConfig
}, {
  id: _constants.OnboardingTopicId.siemMigrations,
  title: _i18n.i18n.translate('xpack.securitySolution.onboarding.topic.automaticMigration', {
    defaultMessage: 'Automatic migration'
  }),
  body: _body_config.siemMigrationsBodyConfig,
  disabledExperimentalFlagRequired: 'siemMigrationsDisabled',
  capabilitiesRequired: `${_constants2.SECURITY_FEATURE_ID}.detections`
}];