"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OnboardingBody = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _centered_loading_spinner = require("../../../common/components/centered_loading_spinner");
var _use_body_config = require("./hooks/use_body_config");
var _onboarding_card_group = require("./onboarding_card_group");
var _onboarding_card_panel = require("./onboarding_card_panel");
var _use_expanded_card = require("./hooks/use_expanded_card");
var _use_completed_cards = require("./hooks/use_completed_cards");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/onboarding/components/onboarding_body/onboarding_body.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OnboardingBody = exports.OnboardingBody = /*#__PURE__*/_react.default.memo(() => {
  const bodyConfig = (0, _use_body_config.useBodyConfig)();
  const {
    expandedCardId,
    setExpandedCardId
  } = (0, _use_expanded_card.useExpandedCard)();
  const {
    isCardComplete,
    setCardComplete,
    getCardCheckCompleteResult,
    checkCardComplete
  } = (0, _use_completed_cards.useCompletedCards)(bodyConfig);
  const createOnToggleExpanded = (0, _react.useCallback)(cardId => () => {
    if (expandedCardId === cardId) {
      setExpandedCardId(null);
    } else {
      setExpandedCardId(cardId);
      checkCardComplete(cardId);
    }
  }, [expandedCardId, setExpandedCardId, checkCardComplete]);
  const createSetCardComplete = (0, _react.useCallback)(cardId => complete => {
    setCardComplete(cardId, complete);
  }, [setCardComplete]);
  const createCheckCardComplete = (0, _react.useCallback)(cardId => () => {
    checkCardComplete(cardId);
  }, [checkCardComplete]);
  const isCardAvailable = (0, _react.useCallback)(cardId => bodyConfig.some(group => group.cards.some(card => card.id === cardId)), [bodyConfig]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }, bodyConfig.map((group, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: index,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_onboarding_card_group.OnboardingCardGroup, {
    title: group.title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 13
    }
  }, group.cards.map(card => {
    const {
      id,
      title,
      icon,
      iconDark,
      badge,
      Component: LazyCardComponent
    } = card;
    const cardCheckCompleteResult = getCardCheckCompleteResult(id);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: id,
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_onboarding_card_panel.OnboardingCardPanel, {
      id: id,
      title: title,
      icon: icon,
      iconDark: iconDark,
      badge: badge,
      checkCompleteResult: cardCheckCompleteResult,
      isExpanded: expandedCardId === id,
      isComplete: isCardComplete(id),
      onToggleExpanded: createOnToggleExpanded(id),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
      fallback: /*#__PURE__*/_react.default.createElement(_centered_loading_spinner.CenteredLoadingSpinner, {
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 80,
          columnNumber: 43
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(LazyCardComponent, {
      setComplete: createSetCardComplete(id),
      checkComplete: createCheckCardComplete(id),
      isCardComplete: isCardComplete,
      isCardAvailable: isCardAvailable,
      setExpandedCardId: setExpandedCardId,
      checkCompleteMetadata: cardCheckCompleteResult === null || cardCheckCompleteResult === void 0 ? void 0 : cardCheckCompleteResult.metadata,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 25
      }
    }))));
  }))))));
});
OnboardingBody.displayName = 'OnboardingBody';