"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OpenFlyoutButtonIcon = exports.OPEN_FLYOUT_BUTTON = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _test_ids = require("./test_ids");
var _containers = require("../../sourcerer/containers");
var _model = require("../../sourcerer/store/model");
var _kibana = require("../../common/lib/kibana");
var _panel_keys = require("../../flyout/document_details/shared/constants/panel_keys");
var _telemetry = require("../../common/lib/telemetry");
var _use_experimental_features = require("../../common/hooks/use_experimental_features");
var _use_selected_patterns = require("../../data_view_manager/hooks/use_selected_patterns");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/notes/components/open_flyout_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OPEN_FLYOUT_BUTTON = exports.OPEN_FLYOUT_BUTTON = _i18n.i18n.translate('xpack.securitySolution.notes.openFlyoutButtonLabel', {
  defaultMessage: 'Expand alert/event details'
});
/**
 * Renders a button to open the alert and event details flyout.
 * This component is meant to be used in timeline and the notes management page, where the cell actions are more basic (no filter in/out).
 */
const OpenFlyoutButtonIcon = exports.OpenFlyoutButtonIcon = /*#__PURE__*/(0, _react.memo)(({
  eventId,
  timelineId,
  iconType
}) => {
  const {
    selectedPatterns: oldSelectedPatterns
  } = (0, _containers.useSourcererDataView)(_model.SourcererScopeName.timeline);
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const experimentalSelectedPatterns = (0, _use_selected_patterns.useSelectedPatterns)(_model.SourcererScopeName.timeline);
  const selectedPatterns = newDataViewPickerEnabled ? experimentalSelectedPatterns : oldSelectedPatterns;
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const {
    openFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const handleClick = (0, _react.useCallback)(() => {
    openFlyout({
      right: {
        id: _panel_keys.DocumentDetailsRightPanelKey,
        params: {
          id: eventId,
          indexName: selectedPatterns.join(','),
          scopeId: _securitysolutionDataTable.TableId.alertsOnAlertsPage // TODO we should update the flyout's code to separate scopeId and preview
        }
      }
    });
    telemetry.reportEvent(_telemetry.DocumentEventTypes.DetailsFlyoutOpened, {
      location: timelineId,
      panel: 'right'
    });
  }, [eventId, openFlyout, selectedPatterns, telemetry, timelineId]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": _test_ids.OPEN_FLYOUT_BUTTON_TEST_ID,
    title: OPEN_FLYOUT_BUTTON,
    "aria-label": OPEN_FLYOUT_BUTTON,
    color: "text",
    iconType: iconType,
    onClick: handleClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  });
});
OpenFlyoutButtonIcon.displayName = 'OpenFlyoutButtonIcon';