"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDateRangePicker = exports.useActionsLogFilter = exports.getActionStatus = exports.DEFAULT_DATE_RANGE_OPTIONS = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _translations = require("../../../../common/translations");
var _experimental_features_service = require("../../../../common/experimental_features_service");
var _constants = require("../../../../../common/endpoint/service/response_actions/constants");
var _translations2 = require("../translations");
var _response_action_status_badge = require("./response_action_status_badge");
var _use_action_history_url_params = require("./use_action_history_url_params");
var _use_get_endpoints_list = require("../../../hooks/endpoint/use_get_endpoints_list");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/endpoint_response_actions_list/components/hooks.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_DATE_RANGE_OPTIONS = exports.DEFAULT_DATE_RANGE_OPTIONS = Object.freeze({
  autoRefreshOptions: {
    enabled: false,
    duration: 10000
  },
  startDate: 'now-24h/h',
  endDate: 'now',
  recentlyUsedDateRanges: []
});
const useDateRangePicker = isFlyout => {
  const {
    setUrlDateRangeFilters,
    startDate: startDateFromUrl,
    endDate: endDateFromUrl
  } = (0, _use_action_history_url_params.useActionHistoryUrlParams)();
  const [dateRangePickerState, setDateRangePickerState] = (0, _react.useState)({
    ...DEFAULT_DATE_RANGE_OPTIONS,
    startDate: isFlyout ? DEFAULT_DATE_RANGE_OPTIONS.startDate : startDateFromUrl !== null && startDateFromUrl !== void 0 ? startDateFromUrl : DEFAULT_DATE_RANGE_OPTIONS.startDate,
    endDate: isFlyout ? DEFAULT_DATE_RANGE_OPTIONS.endDate : endDateFromUrl !== null && endDateFromUrl !== void 0 ? endDateFromUrl : DEFAULT_DATE_RANGE_OPTIONS.endDate
  });
  const updateActionListDateRanges = (0, _react.useCallback)(({
    start,
    end
  }) => {
    setDateRangePickerState(prevState => ({
      ...prevState,
      startDate: start,
      endDate: end
    }));
  }, [setDateRangePickerState]);
  const updateActionListRecentlyUsedDateRanges = (0, _react.useCallback)(recentlyUsedDateRanges => {
    setDateRangePickerState(prevState => ({
      ...prevState,
      recentlyUsedDateRanges
    }));
  }, [setDateRangePickerState]);

  // handle refresh timer update
  const onRefreshChange = (0, _react.useCallback)(evt => {
    setDateRangePickerState(prevState => ({
      ...prevState,
      autoRefreshOptions: {
        enabled: !evt.isPaused,
        duration: evt.refreshInterval
      }
    }));
  }, [setDateRangePickerState]);

  // handle manual time change on date picker
  const onTimeChange = (0, _react.useCallback)(({
    start: newStart,
    end: newEnd
  }) => {
    // update date ranges
    updateActionListDateRanges({
      start: newStart,
      end: newEnd
    });

    // update recently used date ranges
    const newRecentlyUsedDateRanges = [{
      start: newStart,
      end: newEnd
    }, ...dateRangePickerState.recentlyUsedDateRanges.filter(recentlyUsedRange => !(recentlyUsedRange.start === newStart && recentlyUsedRange.end === newEnd)).slice(0, 9)];
    updateActionListRecentlyUsedDateRanges(newRecentlyUsedDateRanges);

    // update URL params for date filters
    if (!isFlyout) {
      setUrlDateRangeFilters({
        startDate: newStart,
        endDate: newEnd
      });
    }
  }, [dateRangePickerState.recentlyUsedDateRanges, isFlyout, setUrlDateRangeFilters, updateActionListDateRanges, updateActionListRecentlyUsedDateRanges]);
  return {
    dateRangePickerState,
    onRefreshChange,
    onTimeChange
  };
};
exports.useDateRangePicker = useDateRangePicker;
const getActionStatus = status => {
  if (status === 'failed') {
    return _translations2.UX_MESSAGES.badge.failed;
  } else if (status === 'successful') {
    return _translations2.UX_MESSAGES.badge.successful;
  } else if (status === 'pending') {
    return _translations2.UX_MESSAGES.badge.pending;
  }
  return '';
};

// maps filter name to a function that updates the query state
exports.getActionStatus = getActionStatus;
/**
 *
 * @param isSentinelOneV1Enabled
 * @param isFlyout
 * @param agentTypes
 * @param types
 * @returns FilterItems
 * @description
 * sets the initial state of the types filter options
 */
const useTypesFilterInitialState = ({
  isFlyout,
  agentTypes,
  types
}) => {
  const isSentinelOneV1Enabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('responseActionsSentinelOneV1Enabled');
  const isMicrosoftDefenderEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('responseActionsMSDefenderEndpointEnabled');
  const isCrowdstrikeEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('responseActionsCrowdstrikeManualHostIsolationEnabled');
  const getFilterOptions = (0, _react.useCallback)(({
    key,
    label,
    checked
  }) => ({
    key,
    label,
    isGroupLabel: false,
    checked,
    'data-test-subj': `types-filter-option`
  }), []);

  // action types filter options
  const defaultFilterOptions = (0, _react.useMemo)(() => _constants.RESPONSE_ACTION_TYPE.map(type => getFilterOptions({
    key: type,
    label: getTypeDisplayName(type),
    checked: !isFlyout && types !== null && types !== void 0 && types.includes(type) ? 'on' : undefined
  })), [getFilterOptions, isFlyout, types]);

  // v8.13 onwards
  // for showing agent types and action types in the same filter
  if (isSentinelOneV1Enabled || isCrowdstrikeEnabled || isMicrosoftDefenderEnabled) {
    if (!isFlyout) {
      return [{
        label: _translations2.FILTER_NAMES.agentTypes,
        isGroupLabel: true
      }, ..._constants.RESPONSE_ACTION_AGENT_TYPE.filter(agentType => {
        switch (agentType) {
          case 'microsoft_defender_endpoint':
            return isMicrosoftDefenderEnabled;
          default:
            return true;
        }
      }).map(type => getFilterOptions({
        key: type,
        label: (0, _translations.getAgentTypeName)(type),
        checked: !isFlyout && agentTypes !== null && agentTypes !== void 0 && agentTypes.includes(type) ? 'on' : undefined
      })), {
        label: _translations2.FILTER_NAMES.actionTypes,
        isGroupLabel: true
      }, ...defaultFilterOptions];
    }
    return [{
      label: _translations2.FILTER_NAMES.actionTypes,
      isGroupLabel: true
    }, ...defaultFilterOptions];
  }
  return defaultFilterOptions;
};
const useActionsLogFilter = ({
  filterName,
  isFlyout,
  searchString
}) => {
  const {
    agentTypes = [],
    commands,
    statuses,
    hosts: selectedAgentIdsFromUrl,
    types = [],
    setUrlActionsFilters,
    setUrlHostsFilters,
    setUrlStatusesFilters,
    setUrlTypesFilters,
    setUrlTypeFilters
  } = (0, _use_action_history_url_params.useActionHistoryUrlParams)();
  const isStatusesFilter = filterName === 'statuses';
  const isHostsFilter = filterName === 'hosts';
  const isTypesFilter = filterName === 'types';
  const {
    data: endpointsList,
    isFetching
  } = (0, _use_get_endpoints_list.useGetEndpointsList)({
    searchString,
    selectedAgentIds: selectedAgentIdsFromUrl
  });

  // track the state of selected hosts via URL
  //  when the page is loaded via selected hosts on URL
  const [areHostsSelectedOnMount, setAreHostsSelectedOnMount] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (selectedAgentIdsFromUrl && selectedAgentIdsFromUrl.length > 0) {
      setAreHostsSelectedOnMount(true);
    }
    // don't sync with changes to further selectedAgentIdsFromUrl
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const typesFilterInitialState = useTypesFilterInitialState({
    isFlyout,
    agentTypes,
    types
  });
  // filter options
  const [items, setItems] = (0, _react.useState)(isTypesFilter ? typesFilterInitialState : isStatusesFilter ? _constants.RESPONSE_ACTION_STATUS.map(statusName => ({
    key: statusName,
    label: /*#__PURE__*/_react.default.createElement(_response_action_status_badge.ResponseActionStatusBadge, {
      color: statusName === 'successful' ? 'success' : statusName === 'failed' ? 'danger' : 'warning',
      status: getActionStatus(statusName),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 322,
        columnNumber: 13
      }
    }),
    searchableLabel: statusName,
    checked: !isFlyout && statuses !== null && statuses !== void 0 && statuses.includes(statusName) ? 'on' : undefined,
    'data-test-subj': `${filterName}-filter-option`
  })) : isHostsFilter ? [] : _constants.RESPONSE_ACTION_API_COMMANDS_NAMES.filter(commandName => {
    const featureFlags = _experimental_features_service.ExperimentalFeaturesService.get();

    // upload - v8.9
    if (commandName === 'upload' && !featureFlags.responseActionUploadEnabled) {
      return false;
    }
    if (commandName === 'runscript' && !featureFlags.microsoftDefenderEndpointRunScriptEnabled && !featureFlags.crowdstrikeRunScriptEnabled) {
      return false;
    }
    if (commandName === 'cancel' && !featureFlags.microsoftDefenderEndpointCancelEnabled) {
      return false;
    }
    return true;
  }).map(commandName => ({
    key: commandName,
    label: _constants.RESPONSE_ACTION_API_COMMAND_TO_CONSOLE_COMMAND_MAP[commandName],
    checked: !isFlyout && commands !== null && commands !== void 0 && commands.map(command => _constants.RESPONSE_CONSOLE_COMMAND_TO_API_COMMAND_MAP[command]).includes(commandName) ? 'on' : undefined,
    'data-test-subj': `${filterName}-filter-option`
  })));
  (0, _react.useEffect)(() => {
    if (isHostsFilter && endpointsList) {
      setItems(endpointsList === null || endpointsList === void 0 ? void 0 : endpointsList.map(list => ({
        key: list.id,
        label: list.name,
        checked: !isFlyout && list.selected ? 'on' : undefined,
        'data-test-subj': `${filterName}-filter-option`
      })));
    }
  }, [endpointsList, filterName, isFlyout, isHostsFilter, setItems]);
  const hasActiveFilters = (0, _react.useMemo)(() => !!items.find(item => item.checked === 'on'), [items]);
  const numActiveFilters = (0, _react.useMemo)(() => items.filter(item => item.checked === 'on').length, [items]);
  const numFilters = (0, _react.useMemo)(() => items.filter(item => item.key && item.checked !== 'on').length, [items]);
  return {
    areHostsSelectedOnMount,
    isLoading: isHostsFilter && isFetching,
    items,
    setItems,
    hasActiveFilters,
    numActiveFilters,
    numFilters,
    setAreHostsSelectedOnMount,
    setUrlActionsFilters,
    setUrlHostsFilters,
    setUrlStatusesFilters,
    setUrlTypeFilters,
    setUrlTypesFilters
  };
};
exports.useActionsLogFilter = useActionsLogFilter;
const getTypeDisplayName = type => {
  if (type === 'automated') {
    return _translations2.FILTER_TYPE_OPTIONS.automated;
  }
  return _translations2.FILTER_TYPE_OPTIONS.manual;
};