"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTableItems = void 0;
var _fp = require("lodash/fp");
var _ruleDataUtils = require("@kbn/rule-data-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTableItems = ({
  dataFormattedForFieldBrowser,
  fieldsByName,
  highlightedFields,
  tableTabState
}) => {
  const {
    pinnedFields,
    showHighlightedFields,
    hideEmptyFields,
    hideAlertFields
  } = tableTabState;
  const pinnedFieldsSet = new Set(pinnedFields);
  const sortedFields = (0, _fp.sortBy)(['field'], dataFormattedForFieldBrowser).map((item, i) => ({
    ...item,
    ...fieldsByName[item.field],
    valuesConcatenated: item.values != null ? item.values.join() : '',
    ariaRowindex: i + 1,
    isPinned: pinnedFieldsSet.has(item.field)
  }));
  const {
    pinnedRows,
    restRows
  } = sortedFields.reduce((acc, curField) => {
    // Hide empty fields
    if (hideEmptyFields && curField.valuesConcatenated === '') {
      return acc;
    }

    // Hide alert fields
    if (hideAlertFields && (curField.field.startsWith(_ruleDataUtils.ALERT_NAMESPACE) || curField.field.startsWith('signal.'))) {
      return acc;
    }

    // Process highlighted fields
    if (showHighlightedFields && !highlightedFields.includes(curField.field)) {
      return acc;
    }

    // Process pinned fields when showHighlightedFields is false
    if (curField.isPinned) {
      acc.pinnedRows.push(curField);
    } else {
      acc.restRows.push(curField);
    }
    return acc;
  }, {
    pinnedRows: [],
    restRows: []
  });
  return [...pinnedRows, ...restRows];
};
exports.getTableItems = getTableItems;