"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableFieldValueCell = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _get_field_format = require("../utils/get_field_format");
var _helpers = require("../../../../common/components/tables/helpers");
var _formatted_field = require("../../../../timelines/components/timeline/body/renderers/formatted_field");
var _constants = require("../../../../timelines/components/timeline/body/renderers/constants");
var _test_ids = require("./test_ids");
var _link_utils = require("../../../shared/utils/link_utils");
var _preview_link = require("../../../shared/components/preview_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/right/components/table_field_value_cell.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Renders the value of a field in the second column of the table
 */
const TableFieldValueCell = exports.TableFieldValueCell = /*#__PURE__*/(0, _react.memo)(({
  scopeId,
  data,
  eventId,
  fieldFromBrowserField,
  ruleId,
  getLinkValue,
  values,
  isRulePreview
}) => {
  if (values == null) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": `event-field-${data.field}`,
    direction: "column",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }, values.map((value, i) => {
    if (fieldFromBrowserField == null) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        key: `${i}-${value}`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 78,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        key: `${i}-${value}`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 79,
          columnNumber: 17
        }
      }, value));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: `${i}-${value}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 13
      }
    }, data.field === _constants.MESSAGE_FIELD_NAME ? /*#__PURE__*/_react.default.createElement(_helpers.OverflowField, {
      value: value,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 17
      }
    }) : (0, _link_utils.isFlyoutLink)({
      field: data.field,
      ruleId,
      scopeId
    }) ? /*#__PURE__*/_react.default.createElement(_preview_link.PreviewLink, {
      field: data.field,
      value: value,
      scopeId: scopeId,
      ruleId: ruleId,
      "data-test-subj": `${_test_ids.FLYOUT_TABLE_PREVIEW_LINK_FIELD_TEST_ID}-${i}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 17
      }
    }) : /*#__PURE__*/_react.default.createElement(_formatted_field.FormattedFieldValue, {
      contextId: `${scopeId}-${eventId}-${data.field}-${i}-${value}`,
      eventId: eventId,
      fieldFormat: (0, _get_field_format.getFieldFormat)(data),
      fieldName: data.field,
      fieldFromBrowserField: fieldFromBrowserField,
      fieldType: data.type,
      isAggregatable: fieldFromBrowserField.aggregatable,
      isObjectArray: data.isObjectArray,
      value: value,
      linkValue: getLinkValue && getLinkValue(data.field),
      truncate: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 17
      }
    }));
  }));
});
TableFieldValueCell.displayName = 'TableFieldValueCell';