"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyzeGraph = exports.ANALYZE_GRAPH_ID = exports.ANALYZER_PREVIEW_BANNER = void 0;
var _react = _interopRequireWildcard(require("react"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _model = require("../../../../sourcerer/store/model");
var _use_which_flyout = require("../../shared/hooks/use_which_flyout");
var _context = require("../../shared/context");
var _test_ids = require("./test_ids");
var _view = require("../../../../resolver/view");
var _use_timeline_data_filters = require("../../../../timelines/containers/use_timeline_data_filters");
var _helpers = require("../../../../helpers");
var _panel_keys = require("../../shared/constants/panel_keys");
var _investigate_in_resolver = require("../../../../detections/components/alerts_table/timeline_actions/investigate_in_resolver");
var _analyzer_preview_container = require("../../right/components/analyzer_preview_container");
var _use_selected_patterns = require("../../../../data_view_manager/hooks/use_selected_patterns");
var _containers = require("../../../../sourcerer/containers");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/left/components/analyze_graph.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ANALYZE_GRAPH_ID = exports.ANALYZE_GRAPH_ID = 'analyze_graph';
const ANALYZER_PREVIEW_BANNER = exports.ANALYZER_PREVIEW_BANNER = {
  title: _i18n.i18n.translate('xpack.securitySolution.flyout.left.visualizations.analyzer.panelPreviewTitle', {
    defaultMessage: 'Preview analyzer panel'
  }),
  backgroundColor: 'warning',
  textColor: 'warning'
};

/**
 * Analyzer graph view displayed in the document details expandable flyout left section under the Visualize tab
 */
const AnalyzeGraph = () => {
  var _useWhichFlyout;
  const {
    eventId,
    scopeId,
    dataAsNestedObject
  } = (0, _context.useDocumentDetailsContext)();
  const isEnabled = (0, _investigate_in_resolver.useIsInvestigateInResolverActionEnabled)(dataAsNestedObject);
  const key = (_useWhichFlyout = (0, _use_which_flyout.useWhichFlyout)()) !== null && _useWhichFlyout !== void 0 ? _useWhichFlyout : 'memory';
  const {
    from,
    to,
    shouldUpdate
  } = (0, _use_timeline_data_filters.useTimelineDataFilters)((0, _helpers.isActiveTimeline)(scopeId));
  const filters = (0, _react.useMemo)(() => ({
    from,
    to
  }), [from, to]);
  const {
    newDataViewPickerEnabled
  } = (0, _use_experimental_features.useEnableExperimental)();
  const {
    selectedPatterns: oldAnalyzerPatterns
  } = (0, _containers.useSourcererDataView)(_model.SourcererScopeName.analyzer);
  const experimentalAnalyzerPatterns = (0, _use_selected_patterns.useSelectedPatterns)(_model.SourcererScopeName.analyzer);
  const selectedPatterns = newDataViewPickerEnabled ? experimentalAnalyzerPatterns : oldAnalyzerPatterns;
  const {
    openPreviewPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const onClick = (0, _react.useCallback)(() => {
    openPreviewPanel({
      id: _panel_keys.DocumentDetailsAnalyzerPanelKey,
      params: {
        resolverComponentInstanceID: `${key}-${scopeId}`,
        banner: ANALYZER_PREVIEW_BANNER
      }
    });
  }, [openPreviewPanel, key, scopeId]);
  return isEnabled ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _test_ids.ANALYZER_GRAPH_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_view.Resolver, {
    databaseDocumentID: eventId,
    resolverComponentInstanceID: `${key}-${scopeId}`,
    indices: selectedPatterns,
    shouldUpdate: shouldUpdate,
    filters: filters,
    isSplitPanel: true,
    showPanelOnClick: onClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_analyzer_preview_container.AnalyzerPreviewNoDataMessage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }));
};
exports.AnalyzeGraph = AnalyzeGraph;
AnalyzeGraph.displayName = 'AnalyzeGraph';