"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isIpFieldPopulated = exports.hasPorts = exports.getPorts = exports.SourceDestinationIp = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _ip = require("../ip");
var _port = require("../port");
var i18n = _interopRequireWildcard(require("../../../../timelines/components/timeline/body/renderers/translations"));
var _geo_fields = require("./geo_fields");
var _ip_with_port = require("./ip_with_port");
var _label = require("./label");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/network/components/source_destination/source_destination_ip.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Returns `true` if the ip field (i.e. `sourceIp`, `destinationIp`) that
 * corresponds with the specified `type` (i.e. `source`, `destination`) is
 * populated. This function will return `false` when the array only contains
 * empty values.
 */
const isIpFieldPopulated = ({
  destinationIp,
  sourceIp,
  type
}) => type === 'source' && sourceIp != null && sourceIp.some(ip => !(0, _fp.isEmpty)(ip)) || type === 'destination' && destinationIp != null && destinationIp.some(ip => !(0, _fp.isEmpty)(ip));

/**
 * Returns an array of ports, filtered such that `null` entries are removed. If
 * the provided `destinationPort` and `sourcePort` do not contain valid ports,
 * an empty array will be returned.
 */
exports.isIpFieldPopulated = isIpFieldPopulated;
const getPorts = ({
  destinationPort,
  sourcePort,
  type
}) => {
  const ports = type === 'source' && sourcePort != null ? sourcePort : type === 'destination' && destinationPort != null ? destinationPort : [];
  return ports.filter(p => p != null).map(p => `${p}`).filter(p => !(0, _fp.isEmpty)(p));
};

/**
 * Returns `true` if the array of ports, filtered to remove invalid entries,
 * has at least one port.
 */
exports.getPorts = getPorts;
const hasPorts = ({
  destinationPort,
  sourcePort,
  type
}) => getPorts({
  destinationPort,
  sourcePort,
  type
}).length > 0;
exports.hasPorts = hasPorts;
const IpAdressesWithPorts = /*#__PURE__*/_react.default.memo(({
  contextId,
  destinationIp,
  destinationPort,
  eventId,
  sourceIp,
  sourcePort,
  type
}) => {
  const ip = type === 'source' ? sourceIp : destinationIp;
  const ipFieldName = type === 'source' ? _ip.SOURCE_IP_FIELD_NAME : _ip.DESTINATION_IP_FIELD_NAME;
  const port = type === 'source' ? sourcePort : destinationPort;
  if (ip == null) {
    return null; // if ip is not populated as an array, ports will be ignored
  }

  // IMPORTANT: The ip and port arrays are parallel arrays; the port at
  // index `i` corresponds with the ip address at index `i`. We must
  // preserve the relationships between the parallel arrays:
  const ipPortPairs = port != null && ip.length === port.length ? ip.map((address, i) => ({
    ip: address,
    port: port[i] != null ? `${port[i]}` : null // use the corresponding port in the parallel array
  })) : ip.map(address => ({
    ip: address,
    port: null // drop the port, because the length of the parallel ip and port arrays is different
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 5
    }
  }, (0, _fp.uniqWith)(_fastDeepEqual.default, ipPortPairs).map(ipPortPair => ipPortPair.ip != null && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: ipPortPair.ip,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_ip_with_port.IpWithPort, {
    contextId: contextId,
    "data-test-subj": `${type}-ip-and-port`,
    eventId: eventId,
    ip: ipPortPair.ip,
    ipFieldName: ipFieldName,
    port: ipPortPair.port,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 15
    }
  }))));
});
IpAdressesWithPorts.displayName = 'IpAdressesWithPorts';

/**
 * When the ip field (i.e. `sourceIp`, `destinationIp`) that corresponds with
 * the specified `type` (i.e. `source`, `destination`) is populated, this component
 * renders:
 * - a label (i.e. `Source` or `Destination`)
 * - a draggable / hyperlinked IP address, when it's populated
 * - a port, hyperlinked to a port lookup service, when it's populated
 * - a summary of geolocation details, when they are populated
 */
const SourceDestinationIp = exports.SourceDestinationIp = /*#__PURE__*/_react.default.memo(({
  contextId,
  scopeId,
  destinationGeoContinentName,
  destinationGeoCountryName,
  destinationGeoCountryIsoCode,
  destinationGeoRegionName,
  destinationGeoCityName,
  destinationIp,
  destinationPort,
  eventId,
  sourceGeoContinentName,
  sourceGeoCountryName,
  sourceGeoCountryIsoCode,
  sourceGeoRegionName,
  sourceGeoCityName,
  sourceIp,
  sourcePort,
  type
}) => {
  const label = type === 'source' ? i18n.SOURCE : i18n.DESTINATION;
  return isIpFieldPopulated({
    destinationIp,
    sourceIp,
    type
  }) || hasPorts({
    destinationPort,
    sourcePort,
    type
  }) ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    "data-test-subj": `${type}-ip-badge`,
    color: "hollow",
    title: "",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    "data-test-subj": `${type}-ip-group`,
    direction: "column",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_label.Label, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 13
    }
  }, label)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 11
    }
  }, isIpFieldPopulated({
    destinationIp,
    sourceIp,
    type
  }) ? /*#__PURE__*/_react.default.createElement(IpAdressesWithPorts, {
    contextId: contextId,
    destinationIp: destinationIp,
    destinationPort: destinationPort,
    eventId: eventId,
    sourceIp: sourceIp,
    sourcePort: sourcePort,
    type: type,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 15
    }
  }, getPorts({
    destinationPort,
    sourcePort,
    type
  }).map((port, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: `port-${port}-${i}`,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_port.Port, {
    "data-test-subj": "port",
    value: port,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 21
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_geo_fields.GeoFields, {
    scopeId: scopeId,
    contextId: contextId,
    destinationGeoContinentName: destinationGeoContinentName,
    destinationGeoCountryName: destinationGeoCountryName,
    destinationGeoCountryIsoCode: destinationGeoCountryIsoCode,
    destinationGeoRegionName: destinationGeoRegionName,
    destinationGeoCityName: destinationGeoCityName,
    eventId: eventId,
    sourceGeoContinentName: sourceGeoContinentName,
    sourceGeoCountryName: sourceGeoCountryName,
    sourceGeoCountryIsoCode: sourceGeoCountryIsoCode,
    sourceGeoRegionName: sourceGeoRegionName,
    sourceGeoCityName: sourceGeoCityName,
    type: type,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 13
    }
  })))) : null;
});
SourceDestinationIp.displayName = 'SourceDestinationIp';