"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ListWithSearch = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _securitysolutionExceptionListComponents = require("@kbn/securitysolution-exception-list-components");
var _use_endpoint_exceptions_capability = require("../../hooks/use_endpoint_exceptions_capability");
var _add_exception_flyout = require("../../../detection_engine/rule_exceptions/components/add_exception_flyout");
var _edit_exception_flyout = require("../../../detection_engine/rule_exceptions/components/edit_exception_flyout");
var i18n = _interopRequireWildcard(require("../../translations"));
var _use_list_with_search = require("../../hooks/use_list_with_search");
var _ = require("..");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/exceptions/components/list_with_search/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ListWithSearchComponent = ({
  list,
  isReadOnly,
  refreshExceptions
}) => {
  const {
    listName,
    exceptions,
    listType,
    lastUpdated,
    pagination,
    emptyViewerTitle,
    emptyViewerBody,
    emptyViewerButtonText,
    viewerStatus,
    ruleReferences,
    showAddExceptionFlyout,
    showEditExceptionFlyout,
    exceptionToEdit,
    exceptionViewerStatus,
    onSearch,
    onAddExceptionClick,
    onDeleteException,
    onEditExceptionItem,
    onPaginationChange,
    handleCancelExceptionItemFlyout,
    handleConfirmExceptionFlyout
  } = (0, _use_list_with_search.useListWithSearchComponent)(list, refreshExceptions);
  const canWriteEndpointExceptions = (0, _use_endpoint_exceptions_capability.useEndpointExceptionsCapability)('crudEndpointExceptions');
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showAddExceptionFlyout ? /*#__PURE__*/_react.default.createElement(_add_exception_flyout.AddExceptionFlyout, {
    rules: null,
    isBulkAction: false,
    isEndpointItem: listType === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT,
    sharedListToAddTo: [list],
    onCancel: handleCancelExceptionItemFlyout,
    onConfirm: handleConfirmExceptionFlyout,
    "data-test-subj": "addExceptionItemFlyoutInList",
    showAlertCloseOptions: false // TODO ask if we need it
    // ask if we need the add to rule/list section and which list should we link the exception here
    ,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }) : viewerStatus === _securitysolutionExceptionListComponents.ViewerStatus.EMPTY || viewerStatus === _securitysolutionExceptionListComponents.ViewerStatus.LOADING ? /*#__PURE__*/_react.default.createElement(_securitysolutionExceptionListComponents.EmptyViewerState, {
    isReadOnly: isReadOnly,
    viewerStatus: viewerStatus,
    onEmptyButtonStateClick: onAddExceptionClick,
    title: i18n.EXCEPTION_LIST_EMPTY_VIEWER_TITLE,
    body: i18n.EXCEPTION_LIST_EMPTY_VIEWER_BODY(listName),
    buttonText: i18n.EXCEPTION_LIST_EMPTY_VIEWER_BUTTON,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showEditExceptionFlyout && exceptionToEdit && /*#__PURE__*/_react.default.createElement(_edit_exception_flyout.EditExceptionFlyout, {
    list: list,
    itemToEdit: exceptionToEdit,
    showAlertCloseOptions: true,
    openedFromListDetailPage: true,
    onCancel: handleCancelExceptionItemFlyout,
    onConfirm: handleConfirmExceptionFlyout,
    "data-test-subj": "editExceptionItemFlyoutInList",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_securitysolutionExceptionListComponents.SearchBar, {
    addExceptionButtonText: listType === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT ? i18n.EXCEPTION_LIST_EMPTY_SEARCH_BAR_BUTTON_ENDPOINT : i18n.EXCEPTION_LIST_EMPTY_SEARCH_BAR_BUTTON,
    listType: listType,
    onSearch: onSearch,
    onAddExceptionClick: onAddExceptionClick,
    isSearching: viewerStatus === _securitysolutionExceptionListComponents.ViewerStatus.SEARCHING,
    isButtonFilled: false,
    buttonIconType: "plusInCircle",
    canAddException: !(listType === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT && canWriteEndpointExceptions),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_.ListExceptionItems, {
    viewerStatus: exceptionViewerStatus,
    listType: listType,
    ruleReferences: ruleReferences,
    isReadOnly: isReadOnly,
    exceptions: exceptions,
    emptyViewerTitle: emptyViewerTitle,
    emptyViewerBody: emptyViewerBody,
    emptyViewerButtonText: emptyViewerButtonText,
    pagination: pagination,
    lastUpdated: lastUpdated,
    onPaginationChange: onPaginationChange,
    onEditExceptionItem: onEditExceptionItem,
    onDeleteException: onDeleteException,
    onCreateExceptionListItem: onAddExceptionClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 13
    }
  }))));
};
ListWithSearchComponent.displayName = 'ListWithSearchComponent';
const ListWithSearch = exports.ListWithSearch = /*#__PURE__*/_react.default.memo(ListWithSearchComponent);
ListWithSearch.displayName = 'ListWithSearch';