"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAskAiAssistant = void 0;
var _react = require("react");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _use_assistant_availability = require("../../../../../assistant/use_assistant_availability");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This category is provided in the prompt context for the assistant
 */
const category = 'insight';
const useAskAiAssistant = ({
  title,
  description,
  replacements,
  suggestedPrompt,
  getPromptContext
}) => {
  const {
    hasAssistantPrivilege,
    isAssistantEnabled,
    isAssistantVisible
  } = (0, _use_assistant_availability.useAssistantAvailability)();
  const {
    promptContextId,
    showAssistantOverlay: showOverlay
  } = (0, _elasticAssistant.useAssistantOverlay)(category, title, description, getPromptContext, null,
  //  UUID
  suggestedPrompt, null,
  // tooltip
  isAssistantEnabled, replacements !== null && replacements !== void 0 ? replacements : null);
  const showAssistantOverlay = (0, _react.useCallback)(() => {
    showOverlay(true);
  }, [showOverlay]);
  const disabled = !hasAssistantPrivilege || !isAssistantVisible || promptContextId == null;
  return (0, _react.useMemo)(() => ({
    promptContextId,
    disabled,
    showAssistantOverlay
  }), [promptContextId, disabled, showAssistantOverlay]);
};
exports.useAskAiAssistant = useAskAiAssistant;