"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ROW_ACTION_FLYOUT_ICON_TEST_ID = exports.OpenFlyoutRowControlColumn = void 0;
var _react = _interopRequireWildcard(require("react"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _panel_keys = require("../../../../flyout/ai_for_soc/constants/panel_keys");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alert_summary/table/open_flyout_row_control_column.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ROW_ACTION_FLYOUT_ICON_TEST_ID = exports.ROW_ACTION_FLYOUT_ICON_TEST_ID = 'alert-summary-table-row-action-flyout-icon';
/**
 * Renders a icon to open the AI for SOC alert summary flyout.
 */
const OpenFlyoutRowControlColumn = exports.OpenFlyoutRowControlColumn = /*#__PURE__*/(0, _react.memo)(({
  alert
}) => {
  const {
    openFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const onOpenFlyout = (0, _react.useCallback)(() => openFlyout({
    right: {
      id: _panel_keys.IOCPanelKey,
      params: {
        id: alert._id,
        indexName: alert._index
      }
    }
  }), [alert, openFlyout]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.alertSummary.table.flyoutIcon', {
      defaultMessage: 'Open flyout'
    }),
    color: "primary",
    "data-test-subj": ROW_ACTION_FLYOUT_ICON_TEST_ID,
    iconType: "expand",
    onClick: onOpenFlyout,
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  });
});
OpenFlyoutRowControlColumn.displayName = 'OpenFlyoutRowControlColumn';