"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatetimeSchemaCellRenderer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _formatted_date = require("../../../../common/components/formatted_date");
var _type_utils = require("../../../utils/type_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alert_summary/table/datetime_schema_cell_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Renders the value of a field of type date (when the schema is 'datetime').
 * Component used in the AI for SOC alert summary table.
 */
const DatetimeSchemaCellRenderer = exports.DatetimeSchemaCellRenderer = /*#__PURE__*/(0, _react.memo)(({
  alert,
  field
}) => {
  const displayValue = (0, _react.useMemo)(() => (0, _type_utils.getAlertFieldValueAsStringOrNumberOrNull)(alert, field), [alert, field]);
  return /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
    fieldName: field,
    value: displayValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 12
    }
  });
});
DatetimeSchemaCellRenderer.displayName = 'DatetimeSchemaCellRenderer';