"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSubfieldChangesForBuildingBlock = void 0;
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSubfieldChangesForBuildingBlock = (oldFieldValue, newFieldValue) => {
  const oldType = (0, _utils.stringifyToSortedJson)(oldFieldValue === null || oldFieldValue === void 0 ? void 0 : oldFieldValue.type);
  const newType = (0, _utils.stringifyToSortedJson)(newFieldValue === null || newFieldValue === void 0 ? void 0 : newFieldValue.type);
  if (oldType !== newType) {
    return [{
      subfieldName: 'type',
      oldSubfieldValue: oldType,
      newSubfieldValue: newType
    }];
  }
  return [];
};
exports.getSubfieldChangesForBuildingBlock = getSubfieldChangesForBuildingBlock;