"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RequiredFieldIcon = RequiredFieldIcon;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _fieldTypes = require("@kbn/field-types");
var _fieldUtils = require("@kbn/field-utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/required_field_icon.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function mapEsTypesToIconProps(type) {
  switch (type) {
    case _fieldTypes.ES_FIELD_TYPES._ID:
    case _fieldTypes.ES_FIELD_TYPES._INDEX:
      /* In Discover "_id" and "_index" have the "keyword" icon. Doing same here for consistency */
      return {
        type: 'keyword'
      };
    case _fieldTypes.ES_FIELD_TYPES.OBJECT:
      return {
        type,
        iconType: 'tokenObject'
      };
    case _fieldTypes.ES_FIELD_TYPES.DATE_NANOS:
      return {
        type: 'date'
      };
    case _fieldTypes.ES_FIELD_TYPES.FLOAT:
    case _fieldTypes.ES_FIELD_TYPES.HALF_FLOAT:
    case _fieldTypes.ES_FIELD_TYPES.SCALED_FLOAT:
    case _fieldTypes.ES_FIELD_TYPES.DOUBLE:
    case _fieldTypes.ES_FIELD_TYPES.INTEGER:
    case _fieldTypes.ES_FIELD_TYPES.LONG:
    case _fieldTypes.ES_FIELD_TYPES.SHORT:
    case _fieldTypes.ES_FIELD_TYPES.UNSIGNED_LONG:
    case _fieldTypes.ES_FIELD_TYPES.AGGREGATE_METRIC_DOUBLE:
    case _fieldTypes.ES_FIELD_TYPES.FLOAT_RANGE:
    case _fieldTypes.ES_FIELD_TYPES.DOUBLE_RANGE:
    case _fieldTypes.ES_FIELD_TYPES.INTEGER_RANGE:
    case _fieldTypes.ES_FIELD_TYPES.LONG_RANGE:
    case _fieldTypes.ES_FIELD_TYPES.BYTE:
    case _fieldTypes.ES_FIELD_TYPES.TOKEN_COUNT:
      return {
        type: 'number'
      };
    default:
      return {
        type
      };
  }
}
/**
 * `FieldIcon` component with addtional icons for types that are not handled by the `FieldIcon` component.
 */
function RequiredFieldIcon({
  type,
  label = type,
  'data-test-subj': dataTestSubj,
  ...props
}) {
  return /*#__PURE__*/_react.default.createElement(_fieldUtils.FieldIcon, (0, _extends2.default)({}, mapEsTypesToIconProps(type), {
    label: label,
    "data-test-subj": dataTestSubj
  }, props, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  }));
}