"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.filterUnsupportedDiffOutcomes = exports.convertFieldToDisplayName = void 0;
exports.getDataSourceProps = getDataSourceProps;
exports.getQueryLanguageLabel = getQueryLanguageLabel;
exports.getSectionedFieldDiffs = void 0;
exports.isFilters = isFilters;
var _lodash = require("lodash");
var _detection_engine = require("../../../../../common/api/detection_engine");
var _constants = require("./constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _utility_types = require("../../../../../common/utility_types");
var _translations2 = require("./diff_components/translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSectionedFieldDiffs = fields => {
  const aboutFields = [];
  const definitionFields = [];
  const scheduleFields = [];
  const setupFields = [];
  for (const field of fields) {
    if (_constants.ABOUT_UPGRADE_FIELD_ORDER.includes(field.fieldsGroupName)) {
      aboutFields.push(field);
    } else if (_constants.DEFINITION_UPGRADE_FIELD_ORDER.includes(field.fieldsGroupName)) {
      definitionFields.push(field);
    } else if (_constants.SCHEDULE_UPGRADE_FIELD_ORDER.includes(field.fieldsGroupName)) {
      scheduleFields.push(field);
    } else if (_constants.SETUP_UPGRADE_FIELD_ORDER.includes(field.fieldsGroupName)) {
      setupFields.push(field);
    }
  }
  return {
    aboutFields,
    definitionFields,
    scheduleFields,
    setupFields
  };
};

/**
 * Filters out any fields that have a `diff_outcome` of
 * `CustomizedValueSameUpdate` as it is not supported for display in the
 * current per-field rule diff flyout
 */
exports.getSectionedFieldDiffs = getSectionedFieldDiffs;
const filterUnsupportedDiffOutcomes = fields => Object.fromEntries(Object.entries(fields).filter(([key, value]) => {
  const diff = value;
  return diff.diff_outcome !== _detection_engine.ThreeWayDiffOutcome.CustomizedValueSameUpdate && diff.diff_outcome !== _detection_engine.ThreeWayDiffOutcome.MissingBaseNoUpdate;
}));
exports.filterUnsupportedDiffOutcomes = filterUnsupportedDiffOutcomes;
function getQueryLanguageLabel(language) {
  switch (language) {
    case 'kuery':
      return i18n.KUERY_LANGUAGE_LABEL;
    case 'lucene':
      return i18n.LUCENE_LANGUAGE_LABEL;
    default:
      return language;
  }
}

/**
 * Assigns type `Filter[]` to an array if every item in it has a `meta` property.
 */
function isFilters(maybeFilters) {
  return maybeFilters.every(f => typeof f === 'object' && f !== null && 'meta' in f && (0, _lodash.isPlainObject)(f.meta));
}
/**
 * Extracts `index` and `dataViewId` from a `data_source` object for use in the `Filters` component.
 */
function getDataSourceProps(dataSource) {
  if (!dataSource) {
    return {
      index: undefined,
      dataViewId: undefined
    };
  }
  if (dataSource.type === _detection_engine.DataSourceType.index_patterns) {
    return {
      index: dataSource.index_patterns,
      dataViewId: undefined
    };
  } else if (dataSource.type === _detection_engine.DataSourceType.data_view) {
    return {
      index: undefined,
      dataViewId: dataSource.data_view_id
    };
  }
  return (0, _utility_types.assertUnreachable)(dataSource);
}
const convertFieldToDisplayName = fieldName => {
  var _fieldToDisplayNameMa;
  return (_fieldToDisplayNameMa = _translations2.fieldToDisplayNameMap[fieldName]) !== null && _fieldToDisplayNameMa !== void 0 ? _fieldToDisplayNameMa : (0, _lodash.startCase)((0, _lodash.camelCase)(fieldName));
};
exports.convertFieldToDisplayName = convertFieldToDisplayName;