"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLegacyUrlRedirect = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLegacyUrlRedirect = ({
  rule,
  spacesApi
}) => {
  (0, _react.useEffect)(() => {
    if (rule) {
      const outcome = rule.outcome;
      if (spacesApi && outcome === 'aliasMatch') {
        // This rule has been resolved from a legacy URL - redirect the user to the new URL and display a toast.
        const path = `rules/id/${rule.id}${window.location.search}${window.location.hash}`;
        spacesApi.ui.redirectLegacyUrl({
          path,
          aliasPurpose: rule.alias_purpose,
          objectNoun: _i18n.i18n.translate('xpack.securitySolution.sections.ruleDetails.redirectObjectNoun', {
            defaultMessage: 'rule'
          })
        });
      }
    }
  }, [rule, spacesApi]);
};
exports.useLegacyUrlRedirect = useLegacyUrlRedirect;