"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoItemsMessage = exports.JobsTableComponent = exports.JobsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _public = require("@kbn/ml-plugin/public");
var _popover_items = require("../../popover_items");
var _kibana = require("../../../lib/kibana");
var i18n = _interopRequireWildcard(require("./translations"));
var _job_switch = require("./job_switch");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/ml_popover/jobs_table/jobs_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const JobNameWrapper = _styledComponents.default.div`
  margin: 5px 0;
`;
JobNameWrapper.displayName = 'JobNameWrapper';

// TODO: Use SASS mixin @include EuiTextTruncate when we switch from styled components
const truncateThreshold = 200;
const JobName = ({
  id,
  name,
  description
}) => {
  const {
    services: {
      ml
    }
  } = (0, _kibana.useKibana)();
  const jobUrl = (0, _public.useMlManagementHref)(ml, {
    page: _public.ML_PAGES.ANOMALY_DETECTION_JOBS_MANAGE,
    pageState: {
      jobId: id
    }
  });
  return /*#__PURE__*/_react.default.createElement(JobNameWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "jobs-table-link",
    href: jobUrl,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  }, name !== null && name !== void 0 ? name : id)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }, description.length > truncateThreshold ? `${description.substring(0, truncateThreshold)}...` : description));
};
const getJobsTableColumns = (isLoading, onJobStateChange) => [{
  name: i18n.COLUMN_JOB_NAME,
  render: ({
    id,
    description,
    customSettings
  }) => {
    var _customSettings$secur;
    return /*#__PURE__*/_react.default.createElement(JobName, {
      id: id,
      name: (_customSettings$secur = customSettings === null || customSettings === void 0 ? void 0 : customSettings.security_app_display_name) !== null && _customSettings$secur !== void 0 ? _customSettings$secur : id,
      description: description,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 7
      }
    });
  }
}, {
  name: i18n.COLUMN_GROUPS,
  render: ({
    groups
  }) => {
    const renderItem = (group, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      key: `${group}-${i}`,
      "data-test-subj": "group",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 9
      }
    }, group);
    return /*#__PURE__*/_react.default.createElement(_popover_items.PopoverItems, {
      items: groups,
      numberOfItemsToDisplay: 0,
      popoverButtonTitle: `${groups.length} Groups`,
      renderItem: renderItem,
      dataTestPrefix: "groups",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 9
      }
    });
  },
  width: '80px'
}, {
  name: i18n.COLUMN_RUN_JOB,
  render: job => job.isCompatible ? /*#__PURE__*/_react.default.createElement(_job_switch.JobSwitch, {
    job: job,
    isSecurityJobsLoading: isLoading,
    onJobStateChange: onJobStateChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    "aria-label": "Warning",
    size: "s",
    type: "warning",
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 9
    }
  }),
  align: _eui.CENTER_ALIGNMENT,
  width: '80px'
}];
const getPaginatedItems = (items, pageIndex, pageSize) => items.slice(pageIndex * pageSize, pageIndex * pageSize + pageSize);
const JobsTableComponent = ({
  isLoading,
  jobs,
  onJobStateChange,
  mlNodesAvailable
}) => {
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const pageSize = 5;
  const pagination = {
    showPerPageOptions: false,
    pageIndex,
    pageSize,
    totalItemCount: jobs.length
  };
  (0, _react.useEffect)(() => {
    setPageIndex(0);
  }, [jobs.length]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "jobs-table",
    columns: getJobsTableColumns(isLoading, onJobStateChange),
    items: getPaginatedItems(jobs.map(j => ({
      ...j,
      isCompatible: mlNodesAvailable ? j.isCompatible : false
    })), pageIndex, pageSize),
    loading: isLoading,
    noItemsMessage: /*#__PURE__*/_react.default.createElement(NoItemsMessage, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 23
      }
    }),
    pagination: pagination,
    responsiveBreakpoint: false,
    onChange: ({
      page
    }) => {
      setPageIndex(page.index);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 5
    }
  });
};
exports.JobsTableComponent = JobsTableComponent;
JobsTableComponent.displayName = 'JobsTableComponent';
const JobsTable = exports.JobsTable = /*#__PURE__*/_react.default.memo(JobsTableComponent);
JobsTable.displayName = 'JobsTable';
const NoItemsMessage = exports.NoItemsMessage = /*#__PURE__*/_react.default.memo(() => {
  const {
    services: {
      ml
    }
  } = (0, _kibana.useKibana)();
  const createNewAnomalyDetectionJobUrl = (0, _public.useMlManagementHref)(ml, {
    page: _public.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_SELECT_INDEX
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 14
      }
    }, i18n.NO_ITEMS_TEXT),
    titleSize: "xs",
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      href: createNewAnomalyDetectionJobUrl,
      iconType: "popout",
      iconSide: "right",
      size: "s",
      target: "_blank",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 197,
        columnNumber: 9
      }
    }, i18n.CREATE_CUSTOM_JOB),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 5
    }
  });
});
NoItemsMessage.displayName = 'NoItemsMessage';